const express = require("express");
const path = require("path");
const cookieParser = require("cookie-parser");
const loggerMorgan = require("morgan");
const cors = require("cors");
const helmet = require("helmet");
const Sentry = require("@sentry/node");
//const xmlparser = require("express-xml-bodyparser");
const compression = require('compression');
const {fileUploadApp, rateLimiter, redirectURL, tokenApp, debugSentry, errorDisplay, errorHandle, validadeTokenApp, cacheRedis, timeoutApp} = require('./helpers/middlewares');

const indexRouter = require("./routes/index");
const dashboardRouter = require("./routes/dashboard");
const usuariosRouter = require("./routes/usuarios");
const clientesRouter = require("./routes/clientes");
const configuracoesRouter = require("./routes/configuracoes");
const POSClientesRouter = require("./routes/pos_clientes");
const eventosRouter = require("./routes/eventos");
const endipointsRouter = require("./routes/endpoints");
const webhookRouter = require("./routes/webhook");
const ficheirosRouter = require("./routes/ficheiros");
const notificacoesRouter = require("./routes/notificacoes");
const pagamentosRouter = require("./routes/pagamentos");
const pagamentosOnlineRouter = require("./routes/pagamentos_online");
const pagamentosIncompletosRouter = require("./routes/pagamentos_incompletos");
const periodoRouter = require("./routes/periodos");
const percentagemTransacionalRouter = require("./routes/percentagem_transacional");
const referenciaRouter = require("./routes/referencias");
const produtosClientesRouter = require("./routes/produtos_clientes");
const tipoProdutoClienteRouter = require("./routes/tipo_produto_clientes");
const tipoUsuarioRouter = require("./routes/tipo_usuario");
const tipoProdutoRouter = require("./routes/tipo_produto");
const credencialRouter = require("./routes/crendencial");
const produtoValoresFixosRouter = require("./routes/produto_valores_fixos");
const smsRouter = require("./routes/sms");
const relatoriosRouter = require("./routes/relatorios");
const transacoesRouter = require("./routes/transacoes");
const afiliadosRouter = require("./routes/afiliados");

require("dotenv").config({ path: path.join(__dirname, '.env') });

const app = express(); 

Sentry.init({
  dsn: "https://35aac96209005871c0b0960ce2e3358d@o4508811616518144.ingest.de.sentry.io/4508811618811984",   
  tracesSampleRate: 1.0,
});

app.use(Sentry.Handlers.requestHandler());
app.use(fileUploadApp);
app.use(rateLimiter);
app.use(helmet({ crossOriginResourcePolicy: false }));

app.use(loggerMorgan("dev"));
app.use(express.json({limit: '100mb'}));
app.use(cookieParser());
app.use("/v1/images", express.static(path.join(__dirname, "assets", "imgs")));
app.use("/v1/contratos", express.static(path.join(__dirname, "assets", "contratos")));
app.use("/v1/reports", express.static(path.join(__dirname, "reports")));
app.use("/v1/fmovs", express.static(path.join(__dirname, "fmovs")));
app.use(cors());
app.use(express.urlencoded({ extended: false }));
// app.use(xmlparser({ trim: false, explicitArray: false }));  
app.use(compression());

// credencial de token

app.get("/", redirectURL);

app.use("/", cacheRedis);

// token request
app.post('/v0/token-app', tokenApp);

app.get("/debug-sentry", debugSentry);

app.use(validadeTokenApp);

app.use("/v1", indexRouter);
app.use("/v1/afiliados", afiliadosRouter);
app.use("/v1/clientes", clientesRouter);
app.use("/v1/configuracoes", configuracoesRouter);
app.use("/v1/dashboard", dashboardRouter);
app.use("/v1/credenciais", credencialRouter);
app.use("/v1/endpoints", endipointsRouter);
app.use("/v1/eventos-endpoints", eventosRouter);
app.use("/v1/ficheiros", ficheirosRouter);
app.use("/v1/notificacoes", notificacoesRouter);
app.use("/v1/pagamentos-incompletos", pagamentosIncompletosRouter);
app.use("/v1/pagamentos", pagamentosRouter);
app.use("/v1/periodos", periodoRouter);
app.use("/v1/percentagem-transacional", percentagemTransacionalRouter);
app.use("/v1/produtos-clientes", produtosClientesRouter);
app.use("/v1/produtos-valores-fixos", produtoValoresFixosRouter);
app.use("/v1/referencias", referenciaRouter);
app.use("/v1/relatorios", relatoriosRouter);
app.use("/v1/sms", smsRouter);
app.use("/v1/tipo-usuario", tipoUsuarioRouter);
app.use("/v1/tipo-produto", tipoProdutoRouter);
app.use("/v1/tipo-produto-cliente", tipoProdutoClienteRouter);
app.use("/v1/transacoes", transacoesRouter);
app.use("/v1/usuarios", usuariosRouter); 
app.use("/v1/webhook", webhookRouter);

app.use("/v1/gpo/pagamentos", pagamentosOnlineRouter); 
app.use("/v1/gpo/pos", POSClientesRouter);

app.use(timeoutApp); 

// manipulador de erros do Sentry para produção
app.use(Sentry.Handlers.errorHandler());

// capturar 404 e encaminhar para o manipulador de erros
app.use(errorHandle);

// manipulador de erros
app.use(errorDisplay);

module.exports = app;
