const models = require('../models/credencial')
const axios = require('axios');
const response = require("../constants/response");
const logger = require('../services/loggerService'); 
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

module.exports.getCredencial = async function(req, res, next) {
  try {
    
      logger("SERVIDOR:getCredencial").info("Á buscar dados")
      const {pagina, limite, entidade = ''} = req.query
      const credencial = await models.getCredencial(pagina, limite, entidade)
      
      res.status(credencial.statusCode).json(credencial)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:getCredencial").error(`Erro ao buscar dados ${error.message}`)
  }
}

module.exports.getCredencialId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getCredencialId").info("Buscar dados")
      const {id_credencial} = req.params
      const credencial = await models.getCredencialId(id_credencial)

      res.status(credencial.statusCode).json(credencial)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:getCredencialId").error(`Erro ao buscar ${error.message}`)
  }
    
}
module.exports.getCredencialEntidade = async function(req, res, next) {
  try {
    
      logger("SERVIDOR:getCredencialEntidade").info("Buscar dados")
      const {entidade} = req.params
      const credencial = await models.getCredencialEntidade(entidade)

      res.status(credencial.statusCode).json(credencial)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:getCredencialEntidade").error(`Erro ao buscar ${error.message}`)
  }
    
}
module.exports.postCredencial = async function(req, res, next) {
  
  try {

      logger("SERVIDOR:postCredencial").info("Iniciando o cadastro")
      const dados = req.body

      const schemaCredenciais = yup.object().shape({
        secret_api: yup.string().min(25).required(),
        entidade: yup.string().min(5).required(),
      })
      
      logger("SERVIDOR:postCredencial").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaCredenciais.validate(dados)

      const result = await models.postCredencial(validar, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } 
  catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postCredencial").error(`Erro a cadastrar ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
}

module.exports.patchCredencialSecreteKey = async function(req, res, next) {
  
  try {

      logger("SERVIDOR:patchCredencialSecreteKey").info("Iniciando atualização")
      const {entidade} = req.params
      const dados = req.body

      const schemaCredenciais = yup.object().shape({
        secret_api: yup.string().min(25).required(),
      })
      
      logger("SERVIDOR:patchCredencialSecreteKey").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaCredenciais.validate(dados)

      const result = await models.patchCredencialSecretKey(entidade, validar, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }
      
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:patchCredencialSecreteKey").error(`Erro a actualizar ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}
  
module.exports.patchCredencial = async function(req, res, next) {
  
  try {

      logger("SERVIDOR:patchCredencial").info("Iniciando atualização")
      const {entidade} = req.params
      const dados = req.body

      const schemaCredenciais = yup.object().shape({
        secret_api: yup.string().min(25).required(),
        entidade: yup.string().min(5).required(),
      })
      
      logger("SERVIDOR:patchCredencial").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaCredenciais.validate(dados)

      const result = await models.patchCredencial(entidade, validar, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:patchCredencial").error(`Erro ao actualizar ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}

module.exports.deleteCredencial = async function(req, res, next) {
  try {

      logger("SERVIDOR:patchCredencialSecreteKey").info("Iniciando atualização")
      const {entidade} = req.params
      const result = await models.deleteCredencial(entidade, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:deleteCredencial").error(`Erro ao deletar ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}