const models = require('../models/dashboard');
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getDashboardTodos = async function(req, res, next) {
  try {  
    
      logger("SERVIDOR:getDashboardTodos").info("Buscar o perfil clientes")
      const results = await models.getDashboardTodos(req)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardTodos").error(`Erro ao buscar o perfil clientes ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}
module.exports.getDashboard = async function(req, res, next) {
  try {  

      logger("SERVIDOR:getDashboard").info("Buscar o perfil do cliente")
      const {cliente} = req.params

      if(!cliente){
        const rs = response("erro", 423, "Valor da entidade inacessivel");
        return rs 
      }

      const results = await models.getDashboard(cliente, req)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboard").error(`Erro ao buscar o perfil cliente ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

