const models = require('../models/eventos')
const response = require("../constants/response");
const yup = require('yup')
const logger = require('../services/loggerService');


module.exports.getEventos = async function(req, res, next) {
   
  try {

      const results = await models.getEventos()
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}   

module.exports.getEventosID = async function(req, res, next) {
   
  try {

      const {id_evento} =  req.params 
      const results = await models.getEventosID(id_evento)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}   

module.exports.postEventos = async function(req, res, next) {
  try {

      logger("SERVIDOR:postClientes").info(`Iniciando cadastrado o cliente`)
      
      const dados =  req.body

      const schemaEventos = yup.object().shape({
        desc_evento: yup.string().required(),
      })

      logger("SERVIDOR:postClientes").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaEventos.validate(dados)
      const result = await models.postEventos(validar)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)

      if(result.status == "sucesso"){        
        sendRequestOnMicroservices({lg, nt, wk})
      }
    
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}

module.exports.patchEventos = async function(req, res, next) {
    try {

        const dados =  req.body
        const {id_evento} =  req.params
        
        const schemaEventos = yup.object().shape({
          desc_evento: yup.string().required(),
        })

        logger("SERVIDOR:postClientes").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaEventos.validate(dados)

        const result = await models.patchEventos(id_evento, validar)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)

        if(result.status == "sucesso"){        
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
  }

module.exports.deleteEventos = async function(req, res, next) {
  try {

      const {id_evento} =  req.params 
      const result = await models.deleteEventos(id_evento)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)

      if(result.status == "sucesso"){        
        sendRequestOnMicroservices({lg, nt, wk})
      }
    
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}