const path = require('path')
const models = require('../models/ficheiros')
const fs =  require('fs')
const response = require("../constants/response");
const logger = require('../services/loggerService');

module.exports.getFicheiros = async function(req, res, next) {

  try {

      const {pagina, limite, total_registros, arquivo = '', sequencia = '', tipo = '', entidade = '', encaminhado = '', conteudo = '', processamento = ''} = req.query
      const results = await models.getFicheiros(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.getFicheirosId = async function(req, res, next) {
    try {    
        const {idficheiros} = req.params        
        const results = await models.getFicheirosId(idficheiros)        
        res.status(results.statusCode).json(results)
      
    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
    }
}

module.exports.getFicheirosMovimentos = async function(req, res, next) {

  try {

      const {pagina, limite, total_registros, ficheiro = '', entidade = ''} = req.query
      const results = await models.getFicheirosMovimentos(pagina, limite, total_registros, ficheiro, entidade)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)

  }
    
}

module.exports.getFicheirosArquivo = async function(req, res, next) {

    try {    

        const {arquivo} = req.params
        const {pagina, limite, total_registros, sequencia = '', tipo = '', entidade = '', encaminhado = '', conteudo = '', processamento = ''} = req.query
        const results = await models.getFicheirosArquivo(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento)
        res.status(results.statusCode).json(results)
      
    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)

    }
    
}

module.exports.getFicheirosEntidade = async function(req, res, next) {

    
    try {    

        const {entidade} = req.params
        const {pagina, limite, total_registros, arquivo = '', sequencia = '', tipo = '', encaminhado = '', conteudo = '', processamento = ''} = req.query
        const results = await models.getFicheirosEntidade(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento)
        res.status(results.statusCode).json(results)
      
    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)

    }
    
}
module.exports.getFicheirosEntidadeDias = async function(req, res, next) {

    
    try {  

        const {entidade, dia_inicio, dia_final} = req.params        
        const {pagina, limite, total_registros, arquivo = '', sequencia = '', tipo = '', encaminhado = '', conteudo = '', processamento = ''} = req.query
        const results = await models.getFicheirosEntidadeDias(pagina, limite, total_registros, dia_inicio, dia_final, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento)
        res.status(results.statusCode).json(results)
        
    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)

    }
    
}
module.exports.getFicheirosDias = async function(req, res, next) {

    
    try {    

        const {dia_inicio, dia_final} = req.params        
        const {pagina, limite, total_registros, arquivo = '', sequencia = '', tipo = '', entidade = '', encaminhado = '', conteudo = '', processamento = ''} = req.query
        const results = await models.getFicheirosDias(pagina, limite, total_registros, dia_inicio, dia_final, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento)
        res.status(results.statusCode).json(results)
      
    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)

    }
    
}

module.exports.getFicheirosTipo = async function(req, res, next) {

    try {    

        const {tipo} = req.params   
        const {pagina, limite, total_registros, arquivo = '', sequencia = '', entidade = '', encaminhado = '', conteudo = '', processamento = ''} = req.query
        const results = await models.getFicheirosTipo(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento)
        res.status(results.statusCode).json(results)
      
    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)

    }
    
}

module.exports.getFicheirosSequencia = async function(req, res, next) {
  try {  

      const {sequencia} = req.params
      const {pagina, limite, total_registros, arquivo = '', tipo = '', entidade = '', encaminhado = '', conteudo = '', processamento = ''} = req.query
      const results = await models.getFicheirosSequencia(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)

  }
  
}

exports.postFicheirosEnviarRelatoriosTranscoes = async function (req, res){

  try {
      
          
          if (req.files) {
      
                let targetFile = req.files.arquivo
                // const ext =  path.extname(targetFile.name)
                // const filename = targetFile.md5+ext
                const filename = targetFile.name
                 
                
                targetFile.mv(path.join(__dirname, '../reports',filename), async (err) => {
                    
                    if (err) {
                        res.status(400).json({status:'erro',mensagem:"Algo aconteceu de errado. Tente outra vez!"})
                        return;
                    }
                    
                  });
                  console.log("Upload feito!")
                  res.status(201).json({status:'successo', messagem:"Upload feito!"})
                  return;
              

          }else{
                console.log(req.files) 
                res.status(400).json({status:'erro',mensagem:"Algo aconteceu de errado. Tente outra vez! Selecionou sua imagem?"})
          }
                 
      
  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
}
