const models = require('../models/notificacoes')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices");

module.exports.getNotificacoes = async function(req, res, next) {
  try {
  
      const {pagina, limite, total_registros, entidade = '', estado = '', leitura = ''} = req.query
      const results = await models.getNotificacoes(pagina, limite, total_registros, entidade, estado, leitura)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.getNotificacoesId = async function(req, res, next) {
  try {

      const {id_notficacao_entidade} = req.params
      const results = await models.getNotificacoesId(id_notficacao_entidade)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.getNotificacoesEntidade = async function(req, res, next) {
  try {

      const {entidade_notificada} = req.params
      const {pagina, limite, total_registros, estado = '', leitura = ''} = req.query
      const results = await models.getNotificacoesEntidade(pagina, limite, total_registros, entidade_notificada, estado, leitura)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.getNotificacoesEntidadeLidas = async function(req, res, next) {
  try {
    
      const {entidade_notificada} = req.params
      const {pagina, limite, total_registros, estado = '', leitura = ''} = req.query
      const results = await models.getNotificacoesEntidadeLidas(pagina, limite, total_registros, entidade_notificada, estado, leitura)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.getNotificacoesEntidadeNaoLidas = async function(req, res, next) {
  try {
    
      const {entidade_notificada} = req.params
      const {pagina, limite, total_registros, estado = '', leitura = ''} = req.query
      const results = await models.getNotificacoesEntidadeNaoLidas(pagina, limite, total_registros, entidade_notificada, estado, leitura)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.getNotificacoesEntidadeDias = async function(req, res, next) {
  try {

      const {entidade_notificada, dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, estado = '', leitura = ''} = req.query
      const results = await models.getNotificacoesEntidadeDias(pagina, limite, total_registros, entidade_notificada, estado, leitura, dia_inicio, dia_final)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.patchNotificacaoMarcarComoLida = async function(req, res, next) {
  try {
    
      const {entidade_notificada, id_notficacao_entidade} = req.params
      const result = await models.patchNotificacaoMarcarComoLida(entidade_notificada, id_notficacao_entidade, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.patchNotificacaoMarcarComoNaoLida = async function(req, res, next) {
  try {

      const {entidade_notificada, id_notficacao_entidade} = req.params
      const result = await models.patchNotificacaoMarcarComoNaoLida(entidade_notificada, id_notficacao_entidade, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}
