const models = require('../models/pagamentos')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getPagamentos = async function(req, res, next) {
  try {
  
      logger("SERVIDOR:getPagamentos").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora_transacao = '', data_transacao} = req.query
      const results = await models.getPagamentos(pagina, limite, total_registros, entidade, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora_transacao, data_transacao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosId").info("Buscar os dados")
      const {id_pagamento} = req.params
      const results = await models.getPagamentosId(id_pagamento)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPagamentosReferencia = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosReferencia").info("Buscar os dados")
      const {referencia} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosReferencia(referencia, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosReferencia").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPagamentosEntidadeReferencia = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosEntidadeReferencia").info("Buscar os dados")
      const {numero_entidade, referencia} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosEntidadeReferencia(numero_entidade, referencia, pagina, limite, total_registros, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosEntidadeReferencia").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPagamentosEntidadeGrupoAfiliados = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosEntidadeGrupoAfiliados").info("Buscar os dados")
      const {numero_entidade, grupo_identificacao} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosEntidadeGrupoAfiliados(numero_entidade, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosEntidadeGrupoAfiliados").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosEntidade = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosEntidade").info("Buscar os dados")
      const {numero_entidade} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora_transacao = '', data_transacao = ''} = req.query
      const results = await models.getPagamentosEntidade(numero_entidade, pagina, limite, total_registros, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora_transacao, data_transacao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosPeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosEntidade").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {periodo} = req.params
      const results = await models.getPagamentosPeriodo(periodo, pagina, limite, total_registros, entidade, montante, tarifa, referencia, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosEntidadePeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosEntidadePeriodo").info("Buscar os dados")
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {numero_entidade,periodo} = req.params
      const results = await models.getPagamentosEntidadePeriodo(numero_entidade, periodo, pagina, limite, total_registros, montante, tarifa, referencia, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosEntidadePeriodo").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosEntidadeDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosEntidadeDias").info("Buscar os dados")
      const {numero_entidade, dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosEntidadeDias(numero_entidade, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosEntidadeDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}
module.exports.getPagamentosDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosDias").info("Buscar os dados")
      const {dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      
      const results = await models.getPagamentosDias(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}