const models = require('../models/pagamentos_incompletos')
const dayjs = require('dayjs')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getPagamentosIncompletos = async function(req, res, next) {
  try {
  
      logger("SERVIDOR:getPagamentosIncompletos").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosIncompletos(pagina, limite, total_registros, entidade, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosIncompletosId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosId").info("Buscar os dados")
      const {id_pagamento} = req.params
      const results = await models.getPagamentosIncompletosId(id_pagamento)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPagamentosIncompletosReferencia = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosReferencia").info("Buscar os dados")
      const {referencia} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosIncompletosReferencia(referencia, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosReferencia").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPagamentosIncompletosEntidadeReferencia = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosEntidadeReferencia").info("Buscar os dados")
      const {numero_entidade, referencia} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosIncompletosEntidadeReferencia(numero_entidade, referencia, pagina, limite, total_registros, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosEntidadeReferencia").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPagamentosIncompletosEntidadeGrupoAfiliados = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosEntidadeGrupoAfiliados").info("Buscar os dados")
      const {numero_entidade, grupo_identificacao} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosIncompletosEntidadeGrupoAfiliados(numero_entidade, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosEntidadeGrupoAfiliados").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosIncompletosEntidade = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosEntidade").info("Buscar os dados")
      const {numero_entidade} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosIncompletosEntidade(numero_entidade, pagina, limite, total_registros, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosIncompletosPeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosPeriodo").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {periodo} = req.params
      const results = await models.getPagamentosIncompletosPeriodo(periodo, pagina, limite, total_registros, entidade, montante, tarifa, referencia, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosPeriodo").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosIncompletosEntidadePeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosEntidadePeriodo").info("Buscar os dados")
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {numero_entidade,periodo} = req.params
      const results = await models.getPagamentosIncompletosEntidadePeriodo(numero_entidade, periodo, pagina, limite, total_registros, montante, tarifa, referencia, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosEntidadePeriodo").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosIncompletosEntidadeDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosEntidadeDias").info("Buscar os dados")
      const {numero_entidade, dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPagamentosIncompletosEntidadeDias(numero_entidade, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosEntidadeDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPagamentosIncompletosDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPagamentosIncompletosDias").info("Buscar os dados")
      const {dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      
      const results = await models.getPagamentosIncompletosDias(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, referencia, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentosIncompletosDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}