const gpo = require('../utils/GPO');
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getGPOPagamentosComerciantesTodos = async function(req, res, next) {
  try {  
    
      logger("SERVIDOR:getGPOPagamentosComerciantesTodos").info("Buscar os dados")
      const results = await gpo.get(`/payments/merchants`)
      
      if(results.status === 200) {

        logger("SERVIDOR:getGPOPagamentosComerciantesTodos").info("Respondendo a requisição")
        const rs = response("sucesso", 200, results.data);
        res.status(rs.statusCode).json(rs)

      }else {

        logger("SERVIDOR:getGPOPagamentosComerciantesTodos").info("Respondendo a requisição")
        const rs = response("erro", results.status, results.data);
        res.status(rs.statusCode).json(rs)

      }
    
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getGPOPagamentosComerciantesTodos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}
module.exports.getGPOPagamentosComerciantesPorComerciante = async function(req, res, next) {   
  try {
  
      logger("SERVIDOR:getGPOPagamentosComerciantesPorComerciante").info("Buscar os dados")
      const {id_comerciante} = req.params
      const results = await gpo.get(`/payments/merchants/${id_comerciante}`)
      
      if(results.status === 200) {

        logger("SERVIDOR:getGPOPagamentosComerciantesPorComerciante").info("Respondendo a requisição")
        const rs = response("sucesso", 200, results.data);
        res.status(rs.statusCode).json(rs)

      }else {

        logger("SERVIDOR:getGPOPagamentosComerciantesPorComerciante").info("Respondendo a requisição")
        const rs = response("erro", results.status, results.data);
        res.status(rs.statusCode).json(rs)

      }

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getGPOPagamentosComerciantesPorComerciante").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}