const models = require('../models/percentagem_transacional')
const response = require("../constants/response");
const yup = require('yup')
const logger = require('../services/loggerService');

module.exports.getPercentualUso = async function(req, res, next) {
  try{

      logger("SERVIDOR:PercentualUso").info(`Buscar dados do percentual de uso`)
      const {tipo_cliente} = req.params
      const {pagina, limite, nome_empresa = '', entidade = ''} = req.query
      const results = await models.getPercentualUso(tipo_cliente, pagina, limite, nome_empresa, entidade);
      
      res.status(results.statusCode).json(results)
    
  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.getPercentualUsoEntidade = async function(req, res, next) {
  try{

      logger("SERVIDOR:getPercentualUsoEntidade").info(`Buscar dados do percentual de uso`)
      const {numero_entidade} = req.params
      const {pagina, limite, nome_empresa = ''} = req.query
      const results = await models.getPercentualUsoEntidade(pagina, limite, nome_empresa, numero_entidade);
      
      res.status(results.statusCode).json(results)
    
  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
  }
    
}

module.exports.patchPercentualAlterarClientes = async function(req, res, next) {
  try{

      logger("SERVIDOR:patchPercentualAlterarClientes").info(`Iniciando`)
      const {entidade} = req.params
      const dados = req.body

      const schemaPercentual = yup.object().shape({
        entidade: yup.string().min(5),
        caraterizacao_cliente:yup.mixed().oneOf(['Comum', 'Especifico'])
      })

      logger("SERVIDOR:patchPercentualAlterarClientes").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaPercentual.validate(dados)

      const result =  await models.patchPercentualAlterarClientes(entidade, validar);

      res.status(result.statusCode).json(result)
    
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:patchPercentualAlterarClientes").error(`Erro ao realizar o percentual ${error.message}`)
      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}

module.exports.patchPercentual = async function(req, res, next) {
  try{

      logger("SERVIDOR:patchPercentual").info(`Iniciando`)
      const {id_por_uso} = req.params
      const dados = req.body

      const schemaPercentual = yup.object().shape({
        entidade: yup.string().min(5),
        valorFixo: yup.number().min(93500).required(),
        percentual: yup.number().required(),
        minimo: yup.number().min(25).required(),
        maximo: yup.string().max(100000).required(),
        formaDeUso:yup.mixed().oneOf(['Percentual', 'Valor Fixo']).default('Valor Fixo')
      })

      logger("SERVIDOR:patchPercentual").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaPercentual.validate(dados)

      const result =  await models.patchPercentual(id_por_uso, validar);

      res.status(result.statusCode).json(result)
    
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:patchPercentual").error(`Erro ao realizar o percentual ${error.message}`)
      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}
