const models = require('../models/periodos')
const response = require("../constants/response");
const logger = require('../services/loggerService');

module.exports.getPeriodos = async function(req, res, next) {
  try {
  
      const {pagina, limite, total_registros, entidade = '',  montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
      const results = await models.getPeriodos(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
      
      res.status(results.statusCode).json(results)    

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPeriodosMesclados = async function(req, res, next) {
  try {
  
      const {pagina, limite, total_registros, entidade = '',  montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
      const results = await models.getPeriodosMesclados(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data, req)
      
      res.status(results.statusCode).json(results)    

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.getPeriodosMescladosPorEntidade = async function(req, res, next) {
  try {
  
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
      const {numero_entidade} = req.params
      const results = await models.getPeriodosMescladosPorEntidade(pagina, limite, total_registros, numero_entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data, req)
      
      res.status(results.statusCode).json(results)    

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.getPeriodosEntidade = async function(req, res, next) {
  try {
  
      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '', hora = '', data  = ''} = req.query
      const {numero_entidade} =  req.params
      const results = await models.getPeriodosEntidade(pagina, limite, total_registros, numero_entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPeriodosPeriodo = async function(req, res, next) {
  try {

      const {pagina, limite, total_registros, entidade = '',  montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
      const {periodo} = req.params
      const results = await models.getPeriodosPeriodo(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPeriodosContabilidade = async function(req, res, next) {
  try {

      const {pagina, limite, total_registros, entidade = '',  montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
      const {periodo} = req.params
      const results = await models.getPeriodosContabilidade(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPeriodosEntidadeContabilidade = async function(req, res, next) {
  try {

      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
      const {periodo, numero_entidade} = req.params
      const results = await models.getPeriodosEntidadeContabilidade(pagina, limite, total_registros, numero_entidade, montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPeriodosContabilidadeData = async function(req, res, next) {
  try {

      const {pagina, limite, total_registros, entidade = '',  montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '', hora = ''} = req.query
      const {periodo, data} = req.params
      const results = await models.getPeriodosContabilidadeData(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPeriodosEntidadeContabilidadeData = async function(req, res, next) {
  try {

      const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '', hora = ''} = req.query
      const {periodo, numero_entidade, data} = req.params
      const results = await models.getPeriodosEntidadeContabilidadeData(pagina, limite, total_registros, numero_entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPeriodosEntidadePeriodo = async function(req, res, next) {
  try {
    const {numero_entidade, periodo} = req.params
    const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
    const results = await models.getPeriodosEntidadePeriodo(pagina, limite, total_registros, numero_entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
    res.json(results);
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
  
}

module.exports.getPeriodosReferencia = async function(req, res, next) {
  try {
    const {referencia} = req.params
    const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
    const results = await models.getPeriodosReferencia(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    res.json(results);
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
    
}

module.exports.getPeriodosEntidadeReferencia = async function(req, res, next) {
  try {
    const {numero_entidade, referencia} = req.params
    const {pagina, limite, total_registros, montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
    const results = await models.getPeriodosEntidadeReferencia(pagina, limite, total_registros, numero_entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    res.json(results);
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
    
}

module.exports.getPeriodosPesquisar = async function(req, res, next) {
  try {
    const {dia_inicio, dia_final} = req.params
    const {pagina, limite, total_registros, entidade = '',  montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
    const results = await models.getPeriodosPesquisar(pagina, limite, total_registros, dia_inicio, dia_final, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
    res.status(results.statusCode).json(results) 
       
  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPeriodosPesquisarMesclados = async function(req, res, next) {
  try {
    const {dia_inicio, dia_final} = req.params
    const {pagina, limite, total_registros, entidade = '',  montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
    const results = await models.getPeriodosPesquisarMesclados(pagina, limite, total_registros, dia_inicio, dia_final, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
    res.status(results.statusCode).json(results) 
       
} catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
}
    
}

module.exports.getPeriodosEntidadePesquisar = async function(req, res, next) {
  try {
    
    const {dia_inicio, dia_final, numero_entidade} = req.params
    const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
    const results = await models.getPeriodosPesquisar(pagina, limite, total_registros, dia_inicio, dia_final, numero_entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
    res.status(results.statusCode).json(results) 
       
  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPeriodosEntidadePesquisarMesclados = async function(req, res, next) {
  try {
    
    const {dia_inicio, dia_final, numero_entidade} = req.params
    const {pagina, limite, total_registros, montante = '', tarifa = '', referencia = '', periodo = '', log_transacao = '', terminal = '', hora = '', data = ''} = req.query
    const results = await models.getPeriodosEntidadePesquisarMesclados(pagina, limite, total_registros, dia_inicio, dia_final, numero_entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data)
    
    res.status(results.statusCode).json(results) 
       
  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}
