const models = require('../models/pos_clientes')
const yup = require('yup')
const {client} = require('../utils/rabbitMQ');
const response = require("../constants/response");
const logger = require('../services/loggerService'); 
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices");

module.exports.getPOS = async function(req, res, next) {
    try {  
        const {pagina, limite, total_registros, entidade = '', pos_nome = '', pos_codigo_emis = '', comerciante_id = '', pos_uuid = '', activo = '', ative_status = '', status_pos = '', nome_empresa = '', email = ''} = req.query
        const results = await models.getPOS(pagina, limite, total_registros, entidade, pos_nome, pos_codigo_emis, comerciante_id, pos_uuid, activo, ative_status, status_pos, nome_empresa, email)
        res.status(results.statusCode).json(results)

    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
    }
    
}

module.exports.getPOSID = async function(req, res, next) {
    try {
        const {gpo_terminais_pos_id} = req.params
        const results = await models.getPOSID(gpo_terminais_pos_id)
        res.status(results.statusCode).json(results)

    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
    }
    
}
module.exports.getPOSComerciante = async function(req, res, next) {
    try {
        const {comerciante_id} = req.params
        const results = await models.getPOSComerciante(comerciante_id)
        res.status(results.statusCode).json(results)

    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
    }
    
}

module.exports.postPOS = async function(req, res, next) {
    try {
        logger("SERVIDOR:postClientes").info(`Iniciando cadastrado o cliente`)
        const dados = req.body

        const schemaGPOPOS = yup.object().shape({
          pos_nome: yup.string().min(5).required(),
          pos_codigo_emis: yup.number().required(),
          comerciante_id: yup.string().required()
        })
  
        logger("SERVIDOR:postClientes").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaGPOPOS.validate(dados)

        const result = await models.postPOS(validar)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)
        
        if(result.status == "sucesso"){

          sendRequestOnMicroservices({lg, nt, wk})

          if(dados?.pos_codigo_emis){

            const queue = 'reference-entities';   
            const channel = await client.rabbitMQ.createChannel() 
            await channel.assertQueue(queue)
            const payload = JSON.stringify({
              kind: "pos:created",
              body:{
                "posName": dados.pos_nome,
                "emisPosCode": dados.pos_codigo_emis,
                "merchantId": dados.comerciante_id
              }
            })
            channel.sendToQueue(queue, Buffer.from(payload));
            console.log("Cadastrar POS: Enviado para fila")
          }
          
        }
      
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
}

module.exports.patchPOS = async function(req, res, next) {

    try {
        const {gpo_terminais_pos_id} = req.params
        logger("SERVIDOR:postClientes").info(`Iniciando cadastrado o cliente`)
        const dados = req.body

        const schemaGPOPOS = yup.object().shape({
          pos_nome: yup.string().min(5).required(),
          pos_codigo_emis: yup.number().required(),
          comerciante_id: yup.string().required()
        })
  
        logger("SERVIDOR:postClientes").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaGPOPOS.validate(dados)

        const result = await models.patchPOS(gpo_terminais_pos_id, validar)    
        
        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)
        
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }
        
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
}
      
module.exports.deletePOS = async function(req, res, next) {

    try {
      const {gpo_terminais_pos_id} = req.params
      const result = await models.deletePOS(gpo_terminais_pos_id)
      
      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
        
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

    } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
        logger("SERVIDOR:PercentualUso").error(`Erro ao buscar percentual de uso ${error.message}`)
    }
    
}