const models = require('../models/produtos_clientes')
const yup = require('yup')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices");

3
module.exports.getTipo_produto = async function(req, res, next) {
  try {  
      logger("SERVIDOR:Clientes").info("Buscar clientes")
      const {pagina, limite, total_registros, nome_empresa = '', nif = '', email = '', numero_entidade = '', responsavel = ''} = req.query
      const results = await models.getTipo_produto(pagina, limite, total_registros, nome_empresa, nif, email, numero_entidade, responsavel); 
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getTipo_produtoID = async function(req, res, next) {
  try {
      const {id_produto} = req.params
      const results = await models.getTipo_produtoID(id_produto)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getTipo_produtoEntidadeTipo = async function(req, res, next) {
  try {
      const {cliente_tipo_produto} = req.params
      const results = await models.getTipo_produtoEntidadeTipo(cliente_tipo_produto)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
}

module.exports.getTipo_produtoEntidade = async function(req, res, next) {
  try {
      const {cliente} = req.params
      const results = await models.getTipo_produtoEntidade(cliente)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
}

module.exports.postTipo_produto = async function(req, res, next) {
  try {

      logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)
      const dados = req.body

      const schemaProdutoCliente = yup.object().shape({
        produto: yup.string().min(5).required(),
        montantes_fixo: yup.mixed().oneOf(['NÃO','SIM']).default('NÃO').required(), 
        cliente_tipo_produto: yup.number().required(),
        codigo_do_produto: yup.number().required(),
      })

      logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaProdutoCliente.validate(dados)

      const result = await models.postTipo_produto(validar)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
            
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, wk, nt})
      } 

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
  
}

module.exports.patchTipo_produto = async function(req, res, next) {

  try {
      logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)
      const {id_produto} = req.params
      const dados = req.body

      const schemaProdutoCliente = yup.object().shape({
        produto: yup.string().min(5).required(),
        montantes_fixo: yup.mixed().oneOf(['NÃO','SIM']).default('NÃO').required(), 
        cliente_tipo_produto: yup.number().required(),
        codigo_do_produto: yup.number().required(),
      })

      logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaProdutoCliente.validate(dados)

      const result = await models.patchTipo_produto(id_produto, validar)
      
      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      
      res.status(result.statusCode).json(result)
            
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, wk, nt})
      } 

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
  
}
    
module.exports.deleteTipo_produto = async function(req, res, next) {

  try {
      const {id_produto} = req.params
      const result = await models.deleteTipo_produto(id_produto)
      
      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
              
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, wk, nt})
      } 
    
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`) 
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}