const models = require('../models/produtos_valores_fixos')
const yup = require('yup')
const logger = require('../services/loggerService'); 
const response = require("../constants/response");
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

module.exports.getFixos = async function(req, res, next) {
   
    try {

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {pagina, limite, total_registros, entidade = '', descricao = "", montante_fixo = ""} = req.query
        const results = await models.getFixos(pagina, limite, total_registros, entidade, descricao, montante_fixo)
        res.status(results.statusCode).json(results);

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
    
}   

module.exports.getFixosID = async function(req, res, next) {
   
    try {
        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_fixo} =  req.params 
        const results = await models.getFixosID(id_fixo)
        res.status(results.statusCode).json(results);

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
    
}   

module.exports.getFixosEntidade = async function(req, res, next) {
   
    try {
        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {entidade_produdo} =  req.params 
        const results = await models.getFixosEntidades(entidade_produdo)
        res.status(results.statusCode).json(results);

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
    
}   

module.exports.postFixos = async function(req, res, next) {
  try {
    
      logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)        
      const dados =  req.body

      const schemaFixos = yup.object().shape({
        produto_cliente: yup.number().required(),
        entidade_produdo: yup.string().required(),
        descricao: yup.string().required(),
        montante_fixo: yup.number().required(),
      })

      logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaFixos.validate(dados)
      const result = await models.postFixos(validar)
      
      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
                    
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      } 

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}

module.exports.patchFixos = async function(req, res, next) {
    try {

        logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)        
        const dados =  req.body

        const schemaFixos = yup.object().shape({
          descricao: yup.string().required(),
          montante_fixo: yup.number().required(),
        })

        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaFixos.validate(dados)
        const {id_fixo} =  req.params 
        const result = await models.patchFixos(id_fixo, validar)
        
        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)
                      
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        } 

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
}

module.exports.deleteFixos = async function(req, res, next) {
  try {

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {id_fixo} =  req.params 
      
      const result = await models.deleteFixos(id_fixo)
      
      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
                      
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      } 

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}