const models = require('../models/retry_endpoints')
const axios = require('axios');
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

module.exports.getLogReqRetry = async function(req, res, next) {
   
    try {
      const eventos = await models.getLogReqRetry()
      res.json(eventos);
    } catch (error) {
      console.error(error.message)
      res.json({status:"erro", mensagem:"Aconteceu algo de errado"})
    }
    
}   

module.exports.getLogReqIDRetry = async function(req, res, next) {
   
    try {
      const {id_automatico_requisicoes} =  req.params 
      const eventos = await models.getLogReqIDRetry(id_automatico_requisicoes)
      res.json(eventos);
    } catch (error) {
      console.error(error.message)
      res.json({status:"erro", mensagem:"Aconteceu algo de errado"})
    }
    
}   

module.exports.getLogReqEntidadeRetry = async function(req, res, next) {
   
    try {
      const {entidade_aceite} =  req.params 
      const eventos = await models.getLogReqEntidadeRetry(entidade_aceite)
      res.json(eventos);
    } catch (error) {
      console.error(error.message)
      res.json({status:"erro", mensagem:"Aconteceu algo de errado"})
    }
    
}   
