const models = require('../models/tipo_produto')
const yup = require('yup')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getTipo_produto = async function(req, res, next) {
  try {  
      logger("SERVIDOR:Clientes").info("Buscar clientes")
      const results = await models.getTipo_produto(); 
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}


module.exports.patchTipo_produto = async function(req, res, next) {

  try {
      logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)        
      const {id_tipo_produto} = req.params
      const dados =  req.body

      const schemaTipoProduto = yup.object().shape({
        registo_produto: yup.string().required(),
        entidade_tipo: yup.mixed().oneOf(['80','81','99']).default('81').required(),
      })

      logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaTipoProduto.validate(dados)
      const result = await models.patchTipo_produto(id_tipo_produto, validar)
      
      var lg = result.logs
      delete result.logs
      
      res.status(result.statusCode).json(result)
                    
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg})
      }
    
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
  
}
