const models = require('../models/tipo_produto')
const yup = require('yup')
const {client} = require('../utils/rabbitMQ');
const response = require("../constants/response");
const logger = require('../services/loggerService'); 
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices");

3
module.exports.getTipo_produto = async function(req, res, next) {
  try {  
      logger("SERVIDOR:Clientes").info("Buscar clientes")
      const {pagina, limite, total_registros, nome_empresa = '', nif = '', email = '', numero_entidade = '', responsavel = ''} = req.query
      const results = await models.getTipo_produto(pagina, limite, total_registros, nome_empresa, nif, email, numero_entidade, responsavel); 
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getTipo_produtoID = async function(req, res, next) {
  try {
    const {id_produto} = req.params
    const results = await models.getTipo_produtoID(id_produto)
    res.json(results);
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
  
}

module.exports.getTipo_produtoEntidadeTipo = async function(req, res, next) {
  try {
    const {cliente_tipo_produto} = req.params
    const results = await models.getTipo_produtoEntidadeTipo(cliente_tipo_produto)
    res.json(results);
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
}

module.exports.getTipo_produtoEntidade = async function(req, res, next) {
  try {
    const {cliente} = req.params
    const results = await models.getTipo_produtoEntidade(cliente)
    res.json(results);
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
}

module.exports.postTipo_produto = async function(req, res, next) {
  try {
    const dados = req.body
    const result = await models.postTipo_produto(dados)

    var wk = result.webhook
    var lg = result.logs
    var nt = result.notification
    
    delete result.webhook
    delete result.logs
    delete result.notification
    
    res.status(201).json(result)
    
    if(lg){
      try {
        await axios.post("http://127.0.0.1:3030", lg);
        
      } catch (erro) {
        console.log(erro.message)
      }
    }

    if(nt){
      try {
        await axios.post("http://127.0.0.1:2020", nt);
        
      } catch (erro) {
        console.log(erro.message)
      }
    }
      

    if(wk){
      try {
        await axios.post("http://127.0.0.1:1010", wk);
        
      } catch (erro) {
        console.log(erro.message)
      }
      
    }
    

      return result
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
  
}

module.exports.patchTipo_produto = async function(req, res, next) {

  try {
    const {id_produto} = req.params
    const dados = req.body
    const result = await models.patchTipo_produto(id_produto, dados)
    
    var wk = result.webhook
    var lg = result.logs
    var nt = result.notification
    
    delete result.webhook
    delete result.logs
    delete result.notification
    
    res.status(202).json(result)
    
    if(lg){
      try {
        await axios.post("http://127.0.0.1:3030", lg);
        
      } catch (erro) {
        console.log(erro.message)
      }
    }

    if(nt){
      try {
        await axios.post("http://127.0.0.1:2020", nt);
        
      } catch (erro) {
        console.log(erro.message)
      }
    }
      

    if(wk){
      try {
        await axios.post("http://127.0.0.1:1010", wk);
        
      } catch (erro) {
        console.log(erro.message)
      }
      
    }
    

      return result
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
  
}
    
module.exports.deleteTipo_produto = async function(req, res, next) {

  try {
    const {id_produto} = req.params
    const result = await models.deleteTipo_produto(id_produto)
    
    var wk = result.webhook
    var lg = result.logs
    var nt = result.notification
    
    delete result.webhook
    delete result.logs
    delete result.notification
    
    res.status(202).json(result)
    
    if(lg){
      try {
        await axios.post("http://127.0.0.1:3030", lg);
        
      } catch (erro) {
        console.log(erro.message)
      }
    }

    if(nt){
      try {
        await axios.post("http://127.0.0.1:2020", nt);
        
      } catch (erro) {
        console.log(erro.message)
      }
    }
      

    if(wk){
      try {
        await axios.post("http://127.0.0.1:1010", wk);
        
      } catch (erro) {
        console.log(erro.message)
      }
      
    }
    

      return result
  } catch (error) {
    console.error(error.message);
    res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
  }
  
}