const models = require('../models/tipo_produto_clientes')
const yup = require('yup')
const logger = require('../services/loggerService'); 
const response = require("../constants/response");
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

module.exports.getTipo_produto = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {pagina, limite, total_registros, nome_empresa = '', registo_produto = '', entidade = ''} = req.query
        const results = await models.getTipo_produto(pagina, limite, total_registros, nome_empresa, registo_produto, entidade)
        res.status(results.statusCode).json(results);

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
    
}

module.exports.getTipo_produtoID = async function(req, res, next) {
    try {

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_tipo_produto_clientes} = req.params
        const results = await models.getTipo_produtoID(id_tipo_produto_clientes)
        res.status(results.statusCode).json(results);

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
    
}

module.exports.getTipo_produtoEntidade = async function(req, res, next) {
    try {

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {cliente} = req.params
        const results = await models.getTipo_produtoEntidade(cliente)
        res.status(results.statusCode).json(results);

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
}

module.exports.getTipo_produtoCliente = async function(req, res, next) { 
    try {

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {cliente} = req.params
        const results = await models.getTipo_produtoCliente(cliente)  
        res.status(results.statusCode).json(results);

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
}

module.exports.postTipo_produto = async function(req, res, next) {
    try {

        logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)        
        const dados =  req.body
  
        const schemaTipoProduto = yup.object().shape({
          tipo_registo: yup.string().required(),
          cliente: yup.number().required(),
        })
  
        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaTipoProduto.validate(dados)
        const result = await models.postTipo_produto(validar)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification      
      
        res.status(result.statusCode).json(result)
              
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        } 

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
}

module.exports.patchTipo_produto = async function(req, res, next) {

    try {
      
        logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)        
        const {id_tipo_produto_clientes} = req.params
        const dados =  req.body
  
        const schemaTipoProduto = yup.object().shape({
          tipo_registo: yup.string().required(),
          cliente: yup.number().required(),
        })
  
        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaTipoProduto.validate(dados)
        const result = await models.patchTipo_produto(id_tipo_produto_clientes, validar)
        
        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)
                
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
  }
      
module.exports.deleteTipo_produto = async function(req, res, next) {

    try {

      logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)
      const {id_tipo_produto_clientes} = req.params
      const result = await models.deleteTipo_produto(id_tipo_produto_clientes)
      
      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
              
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

    } catch (error) {
      console.error(error.message);
      res.json({status:"erro", mensagem:"Algo aconteceu. Tente de novo"})
    }
    
  }