const models = require('../models/transacoes')
const yup = require('yup') 
const path = require('path');
const response = require("../constants/response");
const logger = require('../services/loggerService'); 
const fs = require('fs')
const json2xls = require('json2xls');
const https = require('https')
const FormData = require('form-data');
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

require("dotenv").config({ path: path.join(__dirname, '.env') }); 

module.exports.getTransacoes = async function(req, res, next) {
  try { 
  
    logger("SERVIDOR:getPagamentos").info("Buscar os dados")
    const {pagina, limite, total_registros, entidade = '', montante = '', pagamento = '', referencia = '', percentagem_actual = '', minimo_actual = '', maximo_actual = '' , valor_total = ''} = req.query
    const results = await models.getTransacoes(pagina, limite, total_registros, entidade, montante, pagamento, referencia, percentagem_actual, minimo_actual, maximo_actual, valor_total, req)

    res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getTransacoesId = async function(req, res, next) {
  try {
      const {id_transaccao} = req.params
      const results = await models.getTransacoesId(id_transaccao, req)
      
      res.status(results.statusCode).json(results)
    
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
} 

module.exports.getTransacoesPagamento = async function(req, res, next) {
  try {
      const {pagamento} = req.params
      const results = await models.getTransacoesPagamento(pagamento, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
} 

module.exports.getTransacoesEntidade = async function(req, res, next) {
  try {
      const {pagina, limite, total_registros,} = req.query
      const {numero_entidade} = req.params
      
      const results = await models.getTransacoesPorEntidade(numero_entidade, pagina, limite, total_registros, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getTransacoesPorEntidade = async function(req, res, next) {
  try {
      const {numero_entidade} = req.params
      const {pagina, limite, total_registros} = req.query
      const results = await models.getTransacoesPorEntidade(numero_entidade, pagina, limite,  total_registros, req)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getTransacoesAgrudadoPorEntidade = async function(req, res, next) {
  try {
      const {pagina, limite, total_registros} = req.query
      const results = await models.getTransacoesAgrudadoPorEntidade(pagina, limite, total_registros, req)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getTransacoesAgrudadoPorEntidadeSomatoriaDiario = async function(req, res, next) {
  try {
      const {data} = req.params
      const results = await models.getTransacoesAgrudadoPorEntidadeSomatoriaDiario(data, req)
      res.status(results.statusCode).json(results)
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.postRelatorioTransacao = async function(req, res, next) {
  
  try {
    const dados = req.body

    const schemaRelatorioTransacao = yup.object().shape({
      entidade: yup.string().min(5).required(),
      campos: yup.object().required(),
    })
    
    const validar = await schemaRelatorioTransacao.validate(dados)
    const result = await models.postRelatorioTransacao(validar)
    
    if(result.status === "sucesso"){  

          if(result.mensagem.transacoes.length){
            var xls = json2xls(result.mensagem.transacoes);  
            if(!fs.existsSync(path.join(__dirname, "../reports")))  fs.mkdirSync(path.join(__dirname, "../reports"), { recursive: true });

                fs.appendFileSync(path.join(__dirname, "../reports", result.mensagem.filename), xls, {
                  encoding: "binary"
                });

                try {
                  const config = {
                      maxBodyLength : Infinity,
                      insecureHTTPParser: true,
                      headers: {
                          "Content-Type": "multipart/form-data",
                          Authorization : 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJhcHAiOnsiZG9ubyI6IjNlMWVmOGYwODM2MDZmZTU5M2RiMTY3YTVlMjg3OWQzZTgzYTFlNGQxNTNlMzgzNjQ3M2E2MmZjYjRjN2UzZDU4MmY5NmE2YTFiNWYifX0.u9R7DsHAGBbunFFUiHtsvgUS0h6zxtjD_NPm3np4A50f_MKb0VDOY0mG0o_na3cTuEJzK_k7uiCleB8HFXARsg',
                          Auth : 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJhcHAiOnsiZG9ubyI6IjNlMWVmOGYwODM2MDZmZTU5M2RiMTY3YTVlMjg3OWQzZTgzYTFlNGQxNTNlMzgzNjQ3M2E2MmZjYjRjN2UzZDU4MmY5NmE2YTFiNWYifX0.u9R7DsHAGBbunFFUiHtsvgUS0h6zxtjD_NPm3np4A50f_MKb0VDOY0mG0o_na3cTuEJzK_k7uiCleB8HFXARsg'
                          },
                      httpsAgent: new https.Agent({  
                          rejectUnauthorized: false,
                          keepAlive: true
                      })
                      }

                      const instance = axios.create(config)

                      const fileOrigin = path.join(__dirname, "../reports", result.mensagem.filename) 

                      const fileStream1 = fs.createReadStream(fileOrigin)                     

                      const form1 = new FormData();
                      form1.append('arquivo', fileStream1);
                      
                      
                      const res1 = await instance.post(process.env.HOST_2,form1);
                      console.log("10.10.40.11",res1.data);
                      
              } catch (error) {
                  console.log(error.message)
              }
          }
      
    }

    var wk = result.webhook
    var lg = result.logs
    var nt = result.notification
    
    delete result.webhook
    delete result.logs
    delete result.notification
    
    res.status(result.statusCode).json(result)
      
    if(result.status == "sucesso"){
      sendRequestOnMicroservices({lg, wk, nt})
    } 

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}

module.exports.getTransacoesAgrudadoPorEntidadeSomatoriaMensal = async function(req, res, next) {
  try {
      const {data} = req.params
      const results = await models.getTransacoesAgrudadoPorEntidadeSomatoriaMensal(data, req)
      res.status(results.statusCode).json(results)
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getTransacoesAgrudadoPorEntidadeSomatoria = async function(req, res, next) {
  try {
      const results = await models.getTransacoesAgrudadoPorEntidadeSomatoria(req)
      res.status(results.statusCode).json(results)
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getTransacoesAgrudadoPorEntidadeSomatoriaEntidade = async function(req, res, next) {
  try {
      const {entidade} = req.params
      const results = await models.getTransacoesAgrudadoPorEntidadeSomatoriaEntidade(entidade, req)
      res.status(results.statusCode).json(results)
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.getTransacoesAgrudadoPorEntidadeSomatoriaEntidadeMensalidades = async function(req, res, next) {
  try {
      const {entidade} = req.params
      const results = await models.getTransacoesAgrudadoPorEntidadeSomatoriaEntidadeMensalidades(entidade, req)
      res.status(results.statusCode).json(results)
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getTransacoesEntidadeDias = async function(req, res, next) {
  try {
      const {pagina, limite} = req.query
      const {entidade, dia_inicio, dia_final} = req.params
      const results = await models.getTransacoesEntidadeDias(entidade, dia_inicio, dia_final, pagina, limite, req)
      res.status(results.statusCode).json(results)
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getTransacoesDias = async function(req, res, next) {
  try {
      const {dia_inicio, dia_final} = req.params
      const {pagina, limite} = req.query
      const results = await models.getTransacoesDias(dia_inicio, dia_final, pagina, limite, req)
      res.status(results.statusCode).json(results)
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPagamentos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.postTransacaoPesquisar = async function(req, res, next) {
  try {
    
      const {pagina, limite} = req.query

      const dados = req.body

      const schemaTransacaoPesquisar = yup.object().shape({
        entidade: yup.string(),
        referencia_da_transacao: yup.string(),
        montante_da_transaccao: yup.string(),
        tempo_transacao: yup.string(),
        pagamento: yup.string(),
      })
      
      const validar = await schemaTransacaoPesquisar.validate(dados)      
      const results = await models.postTransacaoPesquisar(validar, pagina, limite)  

      res.status(results.statusCode).json(results)
    
 } catch (error) {
    console.error(error.message)
    logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

    if(error?.path){
      const rs = response("erro", 412, error.message);
      res.status(rs.statusCode).json(rs)        
    }else{  
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
    }
 } 
    
}