const models = require('../models/webhook')
const response = require("../constants/response");
const sendRequestOnMicroservices = require('../helpers/sendRequestOnMicroservices');
const logger = require('../services/loggerService');


module.exports.getWebhook = async function(req, res, next) {
  try {
      const {pagina, limite, total_registros, entidade = '', requisicao = '', url = '', enviado = '', tentativas = ''} = req.query
      const results = await models.getWebhook(pagina, limite, total_registros, entidade, requisicao, url, enviado, tentativas)

      res.status(results.statusCode).json(results)    

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getWebhookEntidade = async function(req, res, next) {
  try {
    
      const {pagina, limite, total_registros, requisicao = '', url = '', enviado = '', tentativas = ''} = req.query
      const {entidade} = req.params
      const results = await models.getWebhookEntidade(pagina, limite, total_registros, entidade, requisicao, url, enviado, tentativas)

    res.status(results.statusCode).json(results)    

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getWebhookIdLog = async function(req, res, next) {
  try {
    
      const {id_logreq} = req.params
      const results = await models.getWebhookIdLog(id_logreq)

      res.status(results.statusCode).json(results)    

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getWebhookLogsFalhas = async function(req, res, next) {

  try {
      const {pagina, limite, total_registros, entidade = '', requisicao = '', url = '', enviado = '', tentativas = ''} = req.query
      const results = await models.getWebhookLogsFalhas(pagina, limite, total_registros, entidade, requisicao, url, enviado, tentativas)

      res.status(results.statusCode).json(results)    

  } catch (error) {
      console.error(error.message);
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getWebhookEntidadeLogsFalhas = async function(req, res, next) {

  try {
    const {pagina, limite, total_registros, requisicao = '', url = '', enviado = '', tentativas = ''} = req.query
    const {entidade} = req.params
    const results = await models.getWebhookEntidadeLogsFalhas(pagina, limite, total_registros, entidade, requisicao, url, enviado, tentativas)

    res.status(results.statusCode).json(results)    

  } catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getWebhookLogsFalhasTentativas = async function(req, res, next) {

  try {
    const {pagina, limite, total_registros, entidade = '', requisicao = '', url = '', enviado = ''} = req.query
    const {log} = req.params
    const results = await models.getWebhookLogsFalhasTentativas(log, pagina, limite, total_registros, entidade, requisicao, url, enviado)

    res.status(results.statusCode).json(results)    

  } catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getWebhookEntidadeLogsFalhasTentativas = async function(req, res, next) {

  try {
    const {pagina, limite, total_registros, requisicao = '', url = '', enviado = ''} = req.query
    const {entidade, log} = req.params
    const results = await models.getWebhookEntidadeLogsFalhasTentativas(log, pagina, limite, total_registros, entidade, requisicao, url, enviado)

    res.status(results.statusCode).json(results)    

  } catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getWebhookLogsPesquisar = async function(req, res, next) {
  try {
    
    const {dia_inicio, dia_final} = req.params
    const {pagina, limite, total_registros, entidade = '', requisicao = '', url = '', enviado = '', tentativas = ''} = req.query
    const results = await models.getWebhookLogsPesquisar(entidade, pagina, limite, total_registros, dia_inicio, dia_final, entidade, requisicao, url, enviado, tentativas)
    
    res.status(results.statusCode).json(results) 
         
  } catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getWebhookEntidadeLogsPesquisar = async function(req, res, next) {
  try {
    
    const {entidade, dia_inicio, dia_final} = req.params
    const {pagina, limite, total_registros, requisicao = '', url = '', enviado = '', tentativas = ''} = req.query
    const results = await models.getWebhookLogsPesquisar(entidade, pagina, limite, total_registros, dia_inicio, dia_final, entidade, requisicao, url, enviado, tentativas)
    
    res.status(results.statusCode).json(results) 
         
  } catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.patchWebhookLogsFalhasTentativasReenviar = async function(req, res, next) {

  try {
    const {entidade, log} = req.params
    const results = await models.patchWebhookLogsFalhasTentativasReenviar(entidade, log)

    let wk = results.webhook
        
    delete results.webhook
    delete results.info

    res.status(results.statusCode).json(results)
    sendRequestOnMicroservices({wk})    

  } catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.patchWebhookLRefazerReenvio = async function(req, res, next) {

  try {
    const {entidade, log} = req.params
    const results = await models.patchWebhookLRefazerReenvio(entidade, log)

    let wk = results.webhook
        
    delete results.webhook
    delete results.info

    res.status(results.statusCode).json(results)
    sendRequestOnMicroservices({wk})     

  } catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.postWebhookLPagamentoTransacao = async function(req, res, next) {

  try {
    const {entidade, periodo, id_transacao} = req.params
    const results = await models.postWebhookLPagamentoTransacao(entidade, periodo, id_transacao)

    let wk = results.webhook
        
    delete results.webhook
    delete results.info

    res.status(results.statusCode).json(results)
    sendRequestOnMicroservices({wk})     

  } catch (error) {
    console.error(error.message);
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}


