const database = require('../config/database')
const pagination = require("../constants/pagination");
const response = require("../constants/response");
const logger = require('../services/loggerService');
const {endpointsFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getEndpoints = async function(pagina, limite, total_registros, entidade, activo, url) {
  try {

      const endpoints = await database('webhooks_endpoints')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("entidade_aceite",`%${entidade}%`)
      .whereLike("activo",`%${activo}%`)
      .whereLike("url",`%${url}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_endpoint','DESC')

      const {registros} = paginationRecords(endpoints, pagina, limite)

      const endpointsLimite = await database('webhooks_endpoints')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("entidade_aceite",`%${entidade}%`)
      .whereLike("activo",`%${activo}%`)
      .whereLike("url",`%${url}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_endpoint','DESC')
      
      const filtered = endpointsFilteres(endpointsLimite)
      registros.total_apresentados = endpointsLimite.length
      registros.entidade = entidade
      registros.activo = activo
      registros.url = url

      delete registros.count

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered, "json", { registros });
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getEndpointsID = async function(id_endpoint) {

  try {

      const endpoints = await database('webhooks_endpoints')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .where({id_endpoint})
      .orderBy('id_endpoint','DESC')
      
      const [filtered] = endpointsFilteres(endpoints)

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered || {});
      return rs
  
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
} 

module.exports.getEndpointsEntidade = async function(pagina, limite, total_registros, entidade, activo, url) {
  try {

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

       if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
          logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
          const rs = response("erro", 423, "Serviço de pagamento inactivo");
          return rs       
      }

      const endpoints = await database('webhooks_endpoints')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("activo",`%${activo}%`)
      .whereLike("url",`%${url}%`)
      .where({entidade_aceite: entidade})
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_endpoint','DESC')

      const {registros} = paginationRecords(endpoints, pagina, limite)

      const endpointsLimite = await database('webhooks_endpoints')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("activo",`%${activo}%`)
      .whereLike("url",`%${url}%`)
      .where({entidade_aceite: entidade})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_endpoint','DESC')
      
      const filtered = endpointsFilteres(endpointsLimite)
      registros.total_apresentados = endpointsLimite.length
      registros.entidade = entidade
      registros.activo = activo
      registros.url = url

      delete registros.count

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered, "json", { registros });
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.postEndpoints = async function(dados, req) {
   
  try {
    
      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: dados.entidade_aceite}) 

      const verifivarEntidade = await database('clientes').where({numero_entidade: dados.entidade_aceite})   

      if(!dados?.gpo_eventos) dados.gpo_eventos = 'PAID'
      
      if(!verifivarEntidade.length){ 
          logger("SERVIDOR:logoutClientes").warn("Entidade inexistente")
          const rs = response("erro", 406, "Entidade inexistente");
          return rs     
      }

       if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
          logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
          const rs = response("erro", 423, "Serviço de pagamento inactivo");
          return rs      
      }
    
      const verify =  await database('webhooks_endpoints').where({url:dados.url}).andWhere({entidade_aceite:dados.entidade_aceite}).andWhere({evento:dados.evento});

      const verifyPrimavera =  await database('webhooks_endpoints').where({tipo_endpoint:"PRIMAVERA"}).andWhere({entidade_aceite:dados.entidade_aceite});
      
      if(verify.length > 0){
          logger("SERVIDOR:logoutClientes").warn("Endpoint já criado")
          const rs = response("erro", 409, "Endpoint já foi criado");
          return rs 
      }
  
      if(verifyPrimavera.length > 0) {
          logger("SERVIDOR:logoutClientes").warn("Endpoint para PRIMAVERA deverá existir somente um")
          const rs = response("erro", 409, "Endpoint para PRIMAVERA deverá existir somente um");
          return rs 
      }

      dados.comerciante_gpo = verifivarEntidade[0].gpo_numero_comerciante
      dados.validade_token = Date.now()
  
      await database('webhooks_endpoints').insert(dados) 
      
      if(dados?.para_servico == "GPO"){
        const verifyClientes =  await database('webhooks_endpoints')
        .where({url:dados.url})
        .andWhere({entidade_aceite:dados.entidade_aceite})
        .join('clientes','clientes.numero_entidade','=','webhooks_endpoints.entidade_aceite')

        logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
        const rs = response("sucesso", 201, "Gravado com sucesso", "json", { 
          endpoint: verifyClientes[0],
          logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "POST" , tabela: "WEBHOOKS_ENDPOINTS", informacao: dados, entidade: dados.entidade_aceite}
        });
        return rs

      }else{

        logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
        const rs = response("sucesso", 201, "Respondeu a solicitação", "json", { 
          logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "POST" , tabela: "WEBHOOKS_ENDPOINTS", informacao: dados, entidade: dados.entidade_aceite}  
        });
        return rs
        
      }
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.patchEndpoints = async function(id_endpoint, dados, req) {
  try { 

      let comerciante_gpo = ""
      if(!dados?.gpo_eventos) dados.gpo_eventos = 'PAID'

      if((dados?.comerciante_gpo) && (dados?.url)){

        const EndpointVerify = await database('webhooks_endpoints').where({comerciante_gpo: dados?.comerciante_gpo}).andWhere({url: dados?.url}).andWhere({gpo_eventos: dados?.gpo_eventos})        

        if(EndpointVerify.length){
          id_endpoint = EndpointVerify[0].id_endpoint 
          comerciante_gpo = EndpointVerify[0].comerciante_gpo 
        }  
    
      }
    
      const entidade = await database("webhooks_endpoints").where({id_endpoint}) 
      
      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade[0].entidade_aceite})        
      
      if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
          logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
          const rs = response("erro", 423, "Serviço de pagamento inactivo");
          return rs       
      }
      
      
      if(comerciante_gpo){
        
          await database("webhooks_endpoints").where({id_endpoint}).update(dados)  
          
          logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
          const rs = response("sucesso", 202, "Endpoint actualizada com sucesso", "json", {
            endpoint: entidade[0],
          });
          return rs 
          
      }else{

          await database("webhooks_endpoints").where({id_endpoint}).update(dados)
          logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
          const rs = response("sucesso", 202, "Endpoint actualizada com sucesso", "json", {
            logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "PATCH" , tabela: "WEBHOOKS_ENDPOINTS", informacao: dados, entidade: entidade[0].entidade_aceite}
          });
          return rs

      }
   
   } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
   }
    
}

module.exports.deleteEndpoints = async function(id_endpoint, req) {
  
  try {
      const entidade = await database("webhooks_endpoints").where({id_endpoint})

      if(!entidade.length){
        logger("SERVIDOR:logoutClientes").warn("Endpoist não encontrado")
        const rs = response("erro", 409, "Endpoist não encontrado");
        return rs      
      }

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade[0].entidade_aceite})        

      if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
          logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
          const rs = response("erro", 423, "Serviço de pagamento inactivo");
          return rs      
      }

      const endpoints = await database('webhooks_endpoints')
      .join('webhooks_logs','webhooks_logs.endpoint','=','webhooks_endpoints.id_endpoint')
      .where({id_endpoint})
      .orderBy('id_endpoint','DESC')
    
      if(endpoints.length > 0) {
          logger("SERVIDOR:logoutClientes").warn("Endpoint não pode ser exluido, por estar a ser usado")
          const rs = response("erro", 409, "Endpoint não pode ser exluido, por estar a ser usado");
          return rs 
      }

      await database("webhooks_endpoints").where({id_endpoint}).del()
      
      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 202, "Endpoint excluido com sucesso", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DELETE" , tabela: "WEBHOOKS_ENDPOINTS", informacao: {id_endpoint}, entidade: entidade[0].entidade_aceite}
      });

      return rs
   
   } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
   }
    
}