const database = require('../config/database')
const response = require("../constants/response");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getEventos = async function(req, res, next) {
  try {

      const eventos = await database('webhooks_eventos')
      .orderBy("id_evento", "desc")

      logger("SERVIDOR:PercentualUso").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, eventos);          
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getEventosID = async function(id_evento) {
  try {

      const [eventos] = await database('webhooks_eventos')
      .where({id_evento})
      
      logger("SERVIDOR:PercentualUso").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, eventos || {});          
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.postEventos = async function(dados) {
  
  try {    
    
      logger("SERVIDOR:postClientes").debug(`Verificar cliente pelo serviço GPO`)
      const verificar = await database('webhooks_eventos').where(dados)

      if(verificar.length){
        logger("SERVIDOR:postClientes").info(`Email usado por outra entidade`)
        const rs = response("erro", 409, "Email usado por outra entidade");
        return rs
      }

      logger("SERVIDOR:postClientes").debug(`Verificar cliente pelo serviço GPO`)
      await database('webhooks_eventos').insert(dados)                   
      
      logger("SERVIDOR:Clientes").info("Gravado com sucesso")
      const rs = response("sucesso", 201, "Gravado com sucesso");
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.patchEventos = async function(id_evento, dados) {
  try {

      logger("SERVIDOR:postClientes").debug(`Verificar cliente pelo serviço GPO`)
      const verificar = await database('webhooks_eventos').where(id_evento)

      if(!verificar.length){
        logger("SERVIDOR:postClientes").info(`Email usado por outra entidade`)
        const rs = response("erro", 409, "Email usado por outra entidade");
        return rs
      }

      logger("SERVIDOR:postClientes").debug(`Verificar cliente pelo serviço GPO`)
      const verificarExistencia = await database('webhooks_eventos').where(id_evento)
      
      if(verificarExistencia.length){
        logger("SERVIDOR:postClientes").info(`Email usado por outra entidade`)
        const rs = response("erro", 409, "Email usado por outra entidade");
        return rs
      }
      
      logger("SERVIDOR:postClientes").debug(`Verificar cliente pelo serviço GPO`)
      await database("webhooks_eventos").where({id_evento}).update(dados)

      logger("SERVIDOR:Clientes").info("Evento actualizada com sucesso")
      const rs = response("sucesso", 202, "Evento actualizada com sucesso");
      return rs
      
   
   } catch (error) {
      console.log(error)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
   }
    
}

module.exports.deleteEventos = async function(id_evento) {
  
  try {
    
      logger("SERVIDOR:postClientes").debug(`Verificar cliente pelo serviço GPO`)
      const verificar = await database('webhooks_eventos').where(id_evento)
      
      if(!verificar.length){
        logger("SERVIDOR:postClientes").info(`Email usado por outra entidade`)
        const rs = response("erro", 409, "Email usado por outra entidade");
        return rs
      }
      
      logger("SERVIDOR:postClientes").debug(`Verificar cliente pelo serviço GPO`)
      await database("webhooks_eventos").where({id_evento}).del()
      
      logger("SERVIDOR:Clientes").info("Evento excluido com sucesso")
      const rs = response("sucesso", 202, "Evento excluido com sucesso");
      return rs
   
   } catch (error) {
     console.error(error.message)
     return {status: "erro", mensagem: "Algo aconteceu. tente de novo"}
   }
    
}