const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getFicheiros = async function(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento) {
  
  try {

      const ficheiros = await database('ficheiros')
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('idficheiros','DESC')

      const {registros} = paginationRecords(ficheiros, pagina, limite)

      const ficheirosLimite = await database('ficheiros')
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('idficheiros','desc')  

      registros.total_apresentados = ficheirosLimite.length
      registros.entidade = entidade
      registros.arquivo = arquivo
      registros.sequencia = sequencia
      registros.encaminhado = encaminhado
      registros.tipo = tipo
      registros.conteudo = conteudo
      registros.processamento = processamento
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheirosLimite, 'json', {registros});          
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFicheirosId = async function(idficheiros) {
  
  
  try {
    
      const [ficheiros] = await database('ficheiros')
      .where({idficheiros})
      
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheiros || {});          
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFicheirosMovimentos = async function(pagina, limite, total_registros, ficheiro, entidade_destino) {
  
  
  try {

      const ficheiros = await database('arquivos_movimentos')
      .whereLike("ficheiro",`%${ficheiro}%`)
      .whereLike("entidade_destino",`%${entidade_destino}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_mov','DESC')

      const {registros} = paginationRecords(ficheiros, pagina, limite)

      const ficheirosLimite = await database('arquivos_movimentos')
      .whereLike("ficheiro",`%${ficheiro}%`)
      .whereLike("entidade_destino",`%${entidade_destino}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_mov','desc')  

      registros.total_apresentados = ficheirosLimite.length
      registros.ficheiro = ficheiro
      registros.entidade = entidade_destino
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheirosLimite, 'json', {registros});          
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFicheirosSequencia = async function(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento) {
  try {

      const ficheiros = await database('ficheiros')
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .where({sequencia})
      .limit(total_registros || pagination.total_limite)
      .orderBy('idficheiros','DESC')
    
      const {registros} = paginationRecords(ficheiros, pagina, limite)

      const ficheirosLimite = await database('ficheiros')
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .where({sequencia})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('idficheiros','desc')  

      registros.total_apresentados = ficheirosLimite.length
      registros.entidade = entidade
      registros.arquivo = arquivo
      registros.sequencia = sequencia
      registros.encaminhado = encaminhado
      registros.tipo = tipo
      registros.conteudo = conteudo
      registros.processamento = processamento
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheirosLimite, 'json', {registros});          
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFicheirosEntidade = async function(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento) {
  try {
      const ficheiros = await database('ficheiros')
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(total_registros || pagination.total_limite)
      .where({entidade})
      .orderBy('idficheiros','DESC')
    
      const {registros} = paginationRecords(ficheiros, pagina, limite)

      const ficheirosLimite = await database('ficheiros')
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .where({entidade})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('idficheiros','desc')  

      registros.total_apresentados = ficheirosLimite.length
      registros.entidade = entidade
      registros.arquivo = arquivo
      registros.sequencia = sequencia
      registros.encaminhado = encaminhado
      registros.tipo = tipo
      registros.conteudo = conteudo
      registros.processamento = processamento
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheirosLimite, 'json', {registros});          
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFicheirosEntidadeDias = async function(pagina, limite, total_registros, dia_inicio, dia_final, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento) {
  try {

      const ficheiros = await database('ficheiros')
      .whereBetween('gerado_em', [dia_inicio, dia_final])
      .andWhere({entidade})
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('idficheiros','desc')
      
      const {registros} = paginationRecords(ficheiros, pagina, limite)

      const ficheirosLimite = await database('ficheiros')
      .whereBetween('gerado_em', [dia_inicio, dia_final])
      .andWhere({entidade})
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('idficheiros','desc')  
    
      registros.total_apresentados = ficheirosLimite.length
      registros.entidade = entidade
      registros.arquivo = arquivo
      registros.sequencia = sequencia
      registros.encaminhado = encaminhado
      registros.tipo = tipo
      registros.conteudo = conteudo
      registros.processamento = processamento
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheirosLimite, 'json', {registros});          
      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFicheirosDias = async function(pagina, limite, total_registros, dia_inicio, dia_final, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento) {
  try {

      const ficheiros = await database('ficheiros')
      .whereBetween('gerado_em', [dia_inicio, dia_final])
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('idficheiros','desc')
      
      const {registros} = paginationRecords(ficheiros, pagina, limite)

      const ficheirosLimite = await database('ficheiros')
      .whereBetween('gerado_em', [dia_inicio, dia_final])
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('idficheiros','desc')  
    
      registros.total_apresentados = ficheirosLimite.length
      registros.entidade = entidade
      registros.arquivo = arquivo
      registros.sequencia = sequencia
      registros.encaminhado = encaminhado
      registros.tipo = tipo
      registros.conteudo = conteudo
      registros.processamento = processamento
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheirosLimite, 'json', {registros});          
      return rs
    
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFicheirosTipo = async function(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento) {
  try {
      const ficheiros = await database('ficheiros')
      .where({tipo})
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('idficheiros','DESC')

      const {registros} = paginationRecords(ficheiros, pagina, limite)

      const ficheirosLimite = await database('ficheiros')
      .where({tipo})
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("arquivo",`%${arquivo}%`)
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('idficheiros','desc')  

      registros.total_apresentados = ficheirosLimite.length
      registros.entidade = entidade
      registros.arquivo = arquivo
      registros.sequencia = sequencia
      registros.encaminhado = encaminhado
      registros.tipo = tipo
      registros.conteudo = conteudo
      registros.processamento = processamento
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheirosLimite, 'json', {registros});          
      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFicheirosArquivo = async function(pagina, limite, total_registros, arquivo, sequencia, tipo, entidade, encaminhado, conteudo, processamento) {
  
  try {

      const ficheiros = await database('ficheiros')
      .where({arquivo})
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('idficheiros','DESC')

      const {registros} = paginationRecords(ficheiros, pagina, limite)

      const ficheirosLimite = await database('ficheiros')
      .where({arquivo})
      .whereIn('tipo', ['FMOV','FSEC','RSEC','FREF','RREF','MEPS'])
      .whereLike("sequencia",`%${sequencia}%`)
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("entidade",`%${entidade}%`)
      .whereLike("encaminhado",`%${encaminhado}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("processamento",`%${processamento}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('idficheiros','desc')  

      registros.total_apresentados = ficheirosLimite.length
      registros.entidade = entidade
      registros.arquivo = arquivo
      registros.sequencia = sequencia
      registros.encaminhado = encaminhado
      registros.tipo = tipo
      registros.conteudo = conteudo
      registros.processamento = processamento
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, ficheirosLimite, 'json', {registros});          
      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}
