const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords")


module.exports.getNotificacoes = async function(pagina, limite, total_registros, entidade, estado, leitura) {
     
     try{
      
        const notificacoes = await database('notificacoes_entidades')
        .whereLike("entidade_notificada",`%${entidade}%`)
        .whereLike("estado",`%${estado}%`)
        .whereLike("leitura",`%${leitura}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_notficacao_entidade','desc') 

        const {registros} = paginationRecords(notificacoes, pagina, limite)

        const notificacoesLimite = await database('notificacoes_entidades') 
        .whereLike("entidade_notificada",`%${entidade}%`)
        .whereLike("estado",`%${estado}%`)
        .whereLike("leitura",`%${leitura}%`)     
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_notficacao_entidade','desc') 

        registros.total_apresentados = notificacoesLimite.length
        registros.entidade = entidade
        registros.estado = estado
        registros.leitura = leitura
      
        logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, notificacoesLimite, 'json', {registros});          
        return rs
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs 
    }
    
}

module.exports.getNotificacoesId = async function(id_notficacao_entidade) {
     
     try{
      
        const [notificacoes] = await database('notificacoes_entidades')
        .where({id_notficacao_entidade})
        .orderBy('id_notficacao_entidade','desc')
      
        logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, notificacoes || {});          
        return rs
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getNotificacoesEntidade = async function(pagina, limite, total_registros, entidade, estado, leitura) {
     
     try{

        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

        if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
            logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
            const rs = response("erro", 423, "Serviço de pagamento inactivo");
            return rs       
        }

        const notificacoes = await database('notificacoes_entidades')
        .where({entidade_notificada: entidade})
        .whereLike("estado",`%${estado}%`)
        .whereLike("leitura",`%${leitura}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_notficacao_entidade','desc') 

        const {registros} = paginationRecords(notificacoes, pagina, limite)

        const notificacoesLimite = await database('notificacoes_entidades') 
        .where({entidade_notificada: entidade})
        .whereLike("estado",`%${estado}%`)
        .whereLike("leitura",`%${leitura}%`)     
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_notficacao_entidade','desc') 

        registros.total_apresentados = notificacoesLimite.length
        registros.entidade = entidade
        registros.estado = estado
        registros.leitura = leitura
      
        logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, notificacoesLimite, 'json', {registros});          
        return rs
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getNotificacoesEntidadeLidas = async function(pagina, limite, total_registros, entidade, estado, leitura) {
     
     try{

        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

        if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
            logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
            const rs = response("erro", 423, "Serviço de pagamento inactivo");
            return rs       
        }

        const notificacoes = await database('notificacoes_entidades')
        .where({entidade_notificada: entidade})
        .andWhere({leitura:'lida'})
        .whereLike("estado",`%${estado}%`)
        .whereLike("leitura",`%${leitura}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_notficacao_entidade','desc')

        const {registros} = paginationRecords(notificacoes, pagina, limite)

        const notificacoesLimite = await database('notificacoes_entidades') 
        .where({entidade_notificada: entidade})
        .andWhere({leitura:'lida'})
        .whereLike("estado",`%${estado}%`)
        .whereLike("leitura",`%${leitura}%`)     
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_notficacao_entidade','desc') 

        registros.total_apresentados = notificacoesLimite.length
        registros.entidade = entidade
        registros.estado = estado
        registros.leitura = leitura
      
        logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, notificacoesLimite, 'json', {registros});          
        return rs
        
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getNotificacoesEntidadeNaoLidas = async function(pagina, limite, total_registros, entidade, estado, leitura) {
     
     try{

        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

        if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
            logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
            const rs = response("erro", 423, "Serviço de pagamento inactivo");
            return rs       
        }

        const notificacoes = await database('notificacoes_entidades')
        .andWhere({leitura:'não lida'})
        .where({entidade_notificada: entidade})
        .whereLike("estado",`%${estado}%`)
        .whereLike("leitura",`%${leitura}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_notficacao_entidade','desc') 

        const {registros} = paginationRecords(notificacoes, pagina, limite)

        const notificacoesLimite = await database('notificacoes_entidades') 
        .andWhere({leitura:'não lida'})
        .where({entidade_notificada: entidade})
        .whereLike("estado",`%${estado}%`)
        .whereLike("leitura",`%${leitura}%`)     
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_notficacao_entidade','desc') 

        registros.total_apresentados = notificacoesLimite.length
        registros.entidade = entidade
        registros.estado = estado
        registros.leitura = leitura
      
        logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, notificacoesLimite, 'json', {registros});          
        return rs
        
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
} 

module.exports.getNotificacoesEntidadeDias = async function(pagina, limite, total_registros, entidade, estado, leitura, dia_inicio, dia_final) {
     
  try{

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

       if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
          logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
          const rs = response("erro", 423, "Serviço de pagamento inactivo");
          return rs      
      }

      const notificacoes = await database('notificacoes_entidades')
      .whereBetween("data_notificada",[dia_inicio, dia_final])
      .whereLike("entidade_notificada",`%${entidade}%`)
      .whereLike("estado",`%${estado}%`)
      .whereLike("leitura",`%${leitura}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_notficacao_entidade','desc')       
    
      const {registros} = paginationRecords(notificacoes, pagina, limite)

      const notificacoesLimite = await database('notificacoes_entidades') 
      .whereBetween("data_notificada",[dia_inicio, dia_final])
      .whereLike("entidade_notificada",`%${entidade}%`)
      .whereLike("estado",`%${estado}%`)
      .whereLike("leitura",`%${leitura}%`)    
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_notficacao_entidade','desc') 

      registros.total_apresentados = notificacoesLimite.length
      registros.entidade = entidade
      registros.estado = estado
      registros.leitura = leitura
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, notificacoesLimite, 'json', {registros});          
      return rs
    
   } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.patchNotificacaoMarcarComoLida = async function(entidade_notificada, id_notficacao_entidade, req) {
     
    try{

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade_notificada})        

      if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
        logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
        const rs = response("erro", 423, "Serviço de pagamento inactivo");
        return rs      
      }

      const verificarNotificacoes = await database('notificacoes_entidades')
      .where({id_notficacao_entidade})
      .andWhere({entidade_notificada})

      if(!verificarNotificacoes.length){
        logger("SERVIDOR:logoutClientes").warn("Notificação não identificada")
        const rs = response("erro", 409, "Notificação não identificada");
        return rs      
      }

      await database('notificacoes_entidades')
      .where({id_notficacao_entidade})
      .andWhere({entidade_notificada})
      .update({leitura:'lida'})
      
      logger("SERVIDOR:postCredencial").info("Marcada como lida com sucesso");
      const rs = response("sucesso", 202, "Marcada como lida com sucesso", 'json', {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "PATCH" , tabela: "NOTIFICAÇÕES", informacao: {entidade_notificada, id_notficacao_entidade}, entidade: entidade_notificada}
      })
        
      return rs;

    
    } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.patchNotificacaoMarcarComoNaoLida = async function(entidade_notificada, id_notficacao_entidade, req) {
     
  try{

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade_notificada})        

       if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
          logger("SERVIDOR:logoutClientes").warn("Serviço de pagamento inactivo")
          const rs = response("erro", 423, "Serviço de pagamento inactivo");
          return rs 
      }

      const pag = await database('notificacoes_entidades')
      .where({id_notficacao_entidade})
      .andWhere({entidade_notificada})
      .update({leitura:'não lida'})

      logger("SERVIDOR:postCredencial").info("Marcada como não lida com sucesso");
      const rs = response("sucesso", 202, "Marcada como não lida com sucesso", 'json', {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "PATCH" , tabela: "NOTIFICAÇÕES", informacao: {entidade_notificada, id_notficacao_entidade}, entidade: entidade_notificada}
      })
          
      return rs;
    
   } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
     
}
 


