const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const {pagamentosFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getPagamentosIncompletos = async function(pagina, limite, total_registros, entidade, montante, tarifa, referencia, periodo, log_transacao, terminal) {
     
    try{

        logger("SERVIDOR:getPagamentosIncompletos").debug("Á carregar dados")
        const pagamentos = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`) 
        .whereLike("numero_entidade",`%${entidade}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_pagamento','desc')

        const {registros} = paginationRecords(pagamentos, pagina, limite)

        logger("SERVIDOR:getPagamentosIncompletos").debug("Á carregar dados com limite")
        const pagamentosLimite = await database('pagamentos_nao_processados')  
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_pagamento','desc')
        
        const filtered = pagamentosFilteres(pagamentosLimite)
        registros.total_apresentados = pagamentosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal

        delete registros.count

        logger("SERVIDOR:getPagamentosIncompletos").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs

    
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPagamentosIncompletos").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPagamentosIncompletosId = async function(id_pagamento) {
     
     try{

        logger("SERVIDOR:getPagamentosIncompletosId").debug("Á carregar dados")
        const pagamentos = await database('pagamentos_nao_processados')
        .where({id_pagamento})
        .orderBy('id_pagamento','desc')
        
        const [filtered] = pagamentosFilteres(pagamentos)

        logger("SERVIDOR:getPagamentosIncompletosId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered || {});            
        return rs      
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPagamentosIncompletosId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPagamentosIncompletosReferencia = async function(referencia, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal) {
     
     try{

        logger("SERVIDOR:getPagamentosIncompletosReferencia").debug("Á carregar dados")
        const pagamentos = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .where({referencia_do_servico: referencia})
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_pagamento','desc')
      
        const {registros} = paginationRecords(pagamentos, pagina, limite)

        logger("SERVIDOR:getPagamentosIncompletosReferencia").debug("Á carregar dados com limite")
        const pagamentosLimite = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .where({referencia_do_servico: referencia})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_pagamento','desc') 
      
        const filtered = pagamentosFilteres(pagamentosLimite)
        registros.total_apresentados = pagamentosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal

        delete registros.count

        logger("SERVIDOR:getPagamentosIncompletosReferencia").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPagamentosIncompletosReferencia").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPagamentosIncompletosEntidadeReferencia = async function(numero_entidade, referencia, pagina, limite, total_registros, montante, tarifa, periodo, log_transacao, terminal) {
     
     try{

        logger("SERVIDOR:getPagamentosIncompletosEntidadeReferencia").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: numero_entidade})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getPagamentosIncompletosEntidadeReferencia").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getPagamentosIncompletosEntidadeReferencia").debug("Á carregar dados")
        const pagamentos = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .where({numero_entidade})
        .andWhere({referencia_do_servico: referencia})
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_pagamento','desc')
      
        const {registros} = paginationRecords(pagamentos, pagina, limite)

        logger("SERVIDOR:getPagamentosIncompletosEntidadeReferencia").debug("Á carregar dados com limite")
        const pagamentosLimite = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .where({numero_entidade})
        .andWhere({referencia_do_servico: referencia})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_pagamento','desc') 
      
        const filtered = pagamentosFilteres(pagamentosLimite)
        registros.total_apresentados = pagamentosLimite.length
        registros.entidade = numero_entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal

        delete registros.count

        logger("SERVIDOR:getPagamentosIncompletosEntidadeReferencia").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPagamentosIncompletosEntidadeReferencia").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPagamentosIncompletosEntidadeGrupoAfiliados = async function(numero_entidade, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, referencia, periodo, log_transacao, terminal) {
     
     try{

        logger("SERVIDOR:getPagamentosIncompletosEntidadeGrupoAfiliados").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: numero_entidade})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getPagamentosIncompletosEntidadeGrupoAfiliados").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        const pagamentos = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .where({numero_entidade})
        .andWhere({grupo_identificacao})
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_pagamento','desc')

        const {registros} = paginationRecords(pagamentos, pagina, limite)

        const pagamentosLimite = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .where({numero_entidade})
        .andWhere({grupo_identificacao})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_pagamento','desc')
      
      
        const filtered = pagamentosFilteres(pagamentosLimite)
        registros.total_apresentados = pagamentosLimite.length
        registros.entidade = numero_entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal

        delete registros.count

        logger("SERVIDOR:getPagamentosIncompletosEntidadeGrupoAfiliados").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPagamentosIncompletosEntidadeGrupoAfiliados").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPagamentosIncompletosEntidade = async function(numero_entidade, pagina, limite, total_registros, montante, tarifa, referencia, periodo, log_transacao, terminal) {
     
     try{

        logger("SERVIDOR:getPagamentosIncompletosEntidade").debug("Á carregar dados de configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: numero_entidade})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getPagamentosIncompletosEntidade").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getPagamentosIncompletosEntidade").debug("Á carregar dados")
        const pagamentos = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .where({numero_entidade})
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_pagamento','desc')    
      
        const {registros} = paginationRecords(pagamentos, pagina, limite)

        logger("SERVIDOR:getPagamentosIncompletosEntidade").debug("Á carregar dados com limite")
        const pagamentosLimite = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .where({numero_entidade})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_pagamento','desc')
      
        const filtered = pagamentosFilteres(pagamentosLimite)
        registros.total_apresentados = pagamentosLimite.length
        registros.entidade = numero_entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal

        delete registros.count

        logger("SERVIDOR:getPagamentosIncompletosEntidade").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPagamentosIncompletosEntidade").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPagamentosIncompletosPeriodo = async function(periodo, pagina, limite, total_registros, entidade, montante, tarifa, referencia, log_transacao, terminal) {
     
  try{

      logger("SERVIDOR:getPagamentosIncompletosPeriodo").debug("Á carregar dados")
      const pagamentos = await database('pagamentos_nao_processados')    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("numero_entidade",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_pagamento','desc')  
              
      const {registros} = paginationRecords(pagamentos, pagina, limite)

      logger("SERVIDOR:getPagamentosIncompletosPeriodo").debug("Á carregar dados com limite")
      const pagamentosLimite = await database('pagamentos_nao_processados')    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("numero_entidade",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_pagamento','desc')
      
      const filtered = pagamentosFilteres(pagamentosLimite)
      registros.total_apresentados = pagamentosLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.referencia = referencia
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      

      logger("SERVIDOR:getPagamentosIncompletosPeriodo").info("Respondeu a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getPagamentosIncompletosPeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getPagamentosIncompletosEntidadePeriodo = async function(numero_entidade, periodo, pagina, limite, total_registros, montante, tarifa, referencia, log_transacao, terminal) {
     
  try{

      logger("SERVIDOR:getPagamentosIncompletosEntidadePeriodo").debug("Á carregar dados da configuração")
      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: numero_entidade})        

      if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
        logger("SERVIDOR:getPagamentosIncompletosEntidadePeriodo").info("Serviço de pagamento por sector inactivo")
        const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
        return rs
      }

      logger("SERVIDOR:getPagamentosIncompletosEntidadePeriodo").debug("Á carregar dados")
      const pagamentos = await database('pagamentos_nao_processados')  
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .where({numero_entidade})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_pagamento','desc')  
              
      const {registros} = paginationRecords(pagamentos, pagina, limite)

      logger("SERVIDOR:getPagamentosIncompletosEntidadePeriodo").debug("Á carregar dados com limite")
      const pagamentosLimite = await database('pagamentos_nao_processados')  
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .where({numero_entidade})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_pagamento','desc')
      
      const filtered = pagamentosFilteres(pagamentosLimite)
      registros.total_apresentados = pagamentosLimite.length
      registros.entidade = numero_entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.referencia = referencia
      registros.log_transacao = log_transacao
      registros.terminal = terminal

      logger("SERVIDOR:getPagamentosIncompletosEntidadePeriodo").info("Respondendo a requisição "+error.message)
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getPagamentosIncompletosEntidadePeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getPagamentosIncompletosEntidadeDias = async function(numero_entidade, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, referencia,  periodo, log_transacao, terminal) {
     
     try{

        logger("SERVIDOR:getPagamentosIncompletosEntidadeDias").debug("Á carregar dados da configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: numero_entidade})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getPagamentosIncompletosEntidadeDias").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getPagamentosIncompletosEntidadeDias").debug("Á carregar dados")
        const pagamentos = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .andWhere({numero_entidade})
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_pagamento','desc')          
        
        const {registros} = paginationRecords(pagamentos, pagina, limite)

        logger("SERVIDOR:getPagamentosIncompletosEntidadeDias").debug("Á carregar dados com limite")
        const pagamentosLimite = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .andWhere({numero_entidade})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_pagamento','desc')

        const filtered = pagamentosFilteres(pagamentosLimite)
        registros.total_apresentados = pagamentosLimite.length
        registros.entidade = numero_entidade
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
  
        logger("SERVIDOR:getPagamentosIncompletosEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPagamentosIncompletosEntidadeDias").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPagamentosIncompletosDias = async function(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, referencia,  periodo, log_transacao, terminal) {
     
     try{
      
        logger("SERVIDOR:getPagamentosIncompletosDias").debug("Á carregar dados")
        const pagamentos = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_pagamento','desc')          
        
        const {registros} = paginationRecords(pagamentos, pagina, limite)

        logger("SERVIDOR:getPagamentosIncompletosDias").debug("Á carregar dados com limite")
        const pagamentosLimite = await database('pagamentos_nao_processados')
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`) 
        .whereLike("numero_entidade",`%${entidade}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_pagamento','desc')

        const filtered = pagamentosFilteres(pagamentosLimite)
        registros.total_apresentados = pagamentosLimite.length
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal

        logger("SERVIDOR:getPagamentosIncompletosDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPagamentosIncompletosDias").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}
