const database = require('../config/database');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getPercentualUso = async function(tipo_cliente, pagina, limite, nome_empresa, numero_entidade) {
  try {
      
      logger("SERVIDOR:PercentualUso").debug("Verificar se existencia das percentagens comuns")
      const percentual = await database('percentagem_por_uso')
      .where({tipo_cliente: tipo_cliente})
      .andWhere({id_por_uso: 1})

      logger("SERVIDOR:PercentualUso").debug("Verificar se existencia de clientes vinculados na pertengem comun")
      const clientes = await database('clientes')
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .where({caraterizacao_cliente: tipo_cliente})
      .andWhere({percentagem_de_uso: 1})
      .orderBy('id_clientes','DESC')

      const {registros} = paginationRecords(clientes, pagina, limite)

      const clientesLimite = await database('clientes')
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .where({caraterizacao_cliente: tipo_cliente})
      .andWhere({percentagem_de_uso: 1})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_clientes','DESC')

      logger("SERVIDOR:PercentualUso").debug("Verificar se existencia de percentagem especificas")
      const percentualEspecifico = await database('percentagem_por_uso')
      .join('clientes', 'percentagem_por_uso.id_por_uso', '=', 'clientes.percentagem_de_uso')
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .where({tipo_cliente: tipo_cliente})
      .andWhere({caraterizacao_cliente: tipo_cliente})
      .orderBy('id_clientes','DESC')

      const {registros: registro1} = paginationRecords(percentualEspecifico, pagina, limite)

      const percentualEspecificoLimite = await database('percentagem_por_uso')
      .join('clientes', 'percentagem_por_uso.id_por_uso', '=', 'clientes.percentagem_de_uso')
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .where({tipo_cliente: tipo_cliente})
      .andWhere({caraterizacao_cliente: tipo_cliente})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_clientes','DESC')

      logger("SERVIDOR:PercentualUso").debug("Verificar se existencia de clientes vinculados na percentagem especifica")
      const percentualEspecificoTodos = await database('clientes')
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .andWhere({caraterizacao_cliente: tipo_cliente})
      .orderBy('id_clientes','DESC')

      const {registros: registro2} = paginationRecords(percentualEspecificoTodos, pagina, limite)

      const percentualEspecificoTodosLimite = await database('clientes')
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .andWhere({caraterizacao_cliente: tipo_cliente})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_clientes','DESC')

      logger("SERVIDOR:PercentualUso").info("Respondeu a solicitação")
      if(String(tipo_cliente).toUpperCase() == String("Comum").toUpperCase()){
        const rs = response("sucesso", 200, {...percentual[0], clientes:clientesLimite}, "json", {registros});          
        return rs
      }
      else{
        const rs = response("sucesso", 200, {percentualEspecifico:percentualEspecificoLimite, percentualEspecificoTodos: percentualEspecificoTodosLimite}, "json", {registros: registro2});          
        return rs
      }

  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:PercentualUso").error(`Erro ao buscar o percentual ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getPercentualUsoEntidade = async function(pagina, limite, nome_empresa, numero_entidade) {
  try {

      logger("SERVIDOR:getPercentualUsoEntidade").debug("Verificar se existencia de percentagem especificas")
      const percentualEspecifico = await database('percentagem_por_uso')
      .join('clientes', 'percentagem_por_uso.id_por_uso', '=', 'clientes.percentagem_de_uso')
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .where({numero_entidade})
      .orderBy('id_clientes','DESC')

      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, percentualEspecifico);          
      return rs

  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.patchPercentualAlterarClientes = async function(entidade, dados) {
  try {

    logger("SERVIDOR:patchClientes").debug(`Verificar se é um  cliente do serviço GPO`)
    const clienteVerify = await database('clientes').where({numero_entidade: entidade})

    if(!clienteVerify.length){
      logger("SERVIDOR:patchClientes").info("Cliente não foi encontrado")
      const rs = response("erro", 409, "Cliente não foi encontrado");
      return rs    
    }    

    const actualizado_em = new Date().toISOString().replace('T',' ').substr(0,19)
    const dataUpdated = {
      caraterizacao_cliente: dados.caraterizacao_cliente,
      percentagem_de_uso:'1'
    }

    if(dados.caraterizacao_cliente == "Comum"){
      
      logger("SERVIDOR:patchClientes").debug(`Deletando a parametrização do custo de uso`)
      await database('percentagem_por_uso')
      .where({tipo_cliente: "Especifico"})
      .where({entidade_especifica: entidade})
      .del()

      dataUpdated.percentagem_de_uso = '1'

    }else{

      dataUpdated.percentagem_de_uso = '0'

    }
    
    
    logger("SERVIDOR:patchClientes").debug(`Actualizado o cliente`)
    await database('clientes').where({numero_entidade: entidade}).update({...dataUpdated, actualizado_em})

    logger("SERVIDOR:patchClientes").info(`Cliente actualizado com sucesso`)
    const rs = response("sucesso", 202, "Cliente actualizado com sucesso", "json", {
      logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "CLIENTES", informacao: {...dados, entidade}, entidade: "01157"}
    });

    return rs

  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:patchPercentual").error(`Erro ao realizar o percentual ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
    
}

module.exports.patchPercentual = async function(id_por_uso, dados) {
  try {

    logger("SERVIDOR:patchPercentual").debug(`Verificar a existencia do registro`)
    const percentual = await database('percentagem_por_uso')
    .andWhere({id_por_uso: id_por_uso})    
    
    if(percentual.length){

      logger("SERVIDOR:patchPercentual").debug(`Actualizar a percentagem do ID ${id_por_uso}`)
      await database('percentagem_por_uso').where({id_por_uso: id_por_uso}).update({...dados})
      const rs = response("sucesso", 202, "Alterado com sucesso", "json");          
      return rs
    }
    else{
      if(id_por_uso == 0){

        if(dados?.entidade){
          const entidade = dados.entidade

          logger("SERVIDOR:patchPercentual").debug(`Deletar o regitro especifico`)
          await database('percentagem_por_uso')
          .where({tipo_cliente: "Especifico"})
          .where({entidade_especifica: null})
          .del()
          
          const dadosInsert = {
            ...dados,
            tipo_cliente: 'Especifico',
            entidade_especifica: entidade
          }

          logger("SERVIDOR:patchPercentual").debug(`Verificar se a entidade já foi parametrizada`)
          const percentualEspecificoExistente = await database('percentagem_por_uso')
          .where({tipo_cliente: "Especifico"})
          .where({entidade_especifica: entidade})

          if(percentualEspecificoExistente.length){
            logger("SERVIDOR:patchPercentual").info(`Entidade já foi parametrizada!`)
            const rs = response("erro", 406, "Entidade já foi parametrizada!", "json");          
            return rs
          }
          
          delete dadosInsert.entidade      
          logger("SERVIDOR:patchPercentual").debug(`Cadastrar a percentagem`)    
          await database('percentagem_por_uso').insert(dadosInsert)
          
          logger("SERVIDOR:patchPercentual").debug(`Á pegar o ultimo registro`)
          const [percentuaNovo] = await database('percentagem_por_uso')
          .max('id_por_uso')

          logger("SERVIDOR:patchPercentual").debug(`Actualizar os dados`)
          await database('clientes').where({numero_entidade:entidade}).update({percentagem_de_uso: percentuaNovo['max(`id_por_uso`)']})

          logger("SERVIDOR:patchPercentual").info(`Percentual por uso parametrizado com sucesso`)
          const rs = response("erro", 202, "Percentual por uso parametrizado com sucesso", "json");          
          return rs
        }
      }
      
      logger("SERVIDOR:patchPercentual").info(`Percentual por uso não encontrado`)
      const rs = response("erro", 409, "Percentual por uso não encontrado", "json");          
      return rs
    }

  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:patchPercentual").error(`Erro ao realizar o percentual ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
    
}
