const database = require('../config/database')
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination")
const {periodosFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords") 

module.exports.getPeriodos = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
  try{

      logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
      const periodos = await database('pagamentos')
      .distinct("Identificacao_Log_EGR")
      .sum("montante_da_operacao AS somatorio")
      .count("id_pagamento AS quantidade")
      .max("data_movimento AS data_periodo") 
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("data_movimento",`%${data}%`)
      .whereLike("numero_entidade",`%${entidade}%`)
      .limit(total_registros || pagination.total_limite)
      .groupBy(['Identificacao_Log_EGR',"data_movimento"])
      .orderBy('Identificacao_Log_EGR','desc')
      .orderBy('data_periodo','desc')

      const {registros} = paginationRecords(periodos, pagina, limite)

      const periodosLimite = await database('pagamentos')
      .distinct("Identificacao_Log_EGR")
      .sum("montante_da_operacao AS somatorio")
      .count("id_pagamento AS quantidade")
      .max("data_movimento AS data_periodo")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("data_movimento",`%${data}%`)
      .whereLike("numero_entidade",`%${entidade}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .groupBy(['Identificacao_Log_EGR',"data_movimento"])
      .orderBy('Identificacao_Log_EGR','desc')
      .orderBy('data_periodo','desc')
    
      const filtered = periodosFilteres(periodosLimite)
      registros.total_apresentados = periodosLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.referencia = referencia
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.hora = hora
      registros.data = data

      delete registros.count

      logger("SERVIDOR:getPagamentos").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs
    
   } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getPagamentos").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getPeriodosMesclados = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data, req) {
     
  try{

      logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
      const periodos = await database('pagamentos')
      .distinct("Identificacao_Log_EGR")
      .sum("montante_da_operacao AS somatorio")
      .count("id_pagamento AS quantidade")
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("data_movimento",`%${data}%`)
      .whereLike("numero_entidade",`%${entidade}%`)
      .limit(total_registros || pagination.total_limite)
      .groupBy(['Identificacao_Log_EGR'])
      .orderBy('Identificacao_Log_EGR','desc')

      const {registros} = paginationRecords(periodos, pagina, limite)

      const periodosLimite = await database('pagamentos')
      .distinct("Identificacao_Log_EGR")
      .sum("montante_da_operacao AS somatorio")
      .count("id_pagamento AS quantidade")   
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("data_movimento",`%${data}%`)
      .whereLike("numero_entidade",`%${entidade}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .groupBy(['Identificacao_Log_EGR'])
      .orderBy('Identificacao_Log_EGR','desc')
    
      const filtered = periodosFilteres(periodosLimite)
      registros.total_apresentados = periodosLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.referencia = referencia
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.hora = hora
      registros.data = data

      delete registros.count

      logger("SERVIDOR:getPagamentos").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros,
        url: req.originalUrl
      });
          
      return rs
    
   } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getPagamentos").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}


module.exports.getPeriodosMescladosPorEntidade = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data, req) {
     
  try{

      logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
      const periodos = await database('pagamentos')
      .distinct("Identificacao_Log_EGR AS periodo")
      .sum("montante_da_operacao AS somatorio")
      .sum("tarifa_aplicada_a_operacao AS tarifa_somada")
      .count("id_pagamento AS quantidade")
      .max("data_movimento AS data_periodo")
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("data_movimento",`%${data}%`)
      .where({numero_entidade: entidade})
      .limit(total_registros || pagination.total_limite)
      .groupBy(['Identificacao_Log_EGR'])
      .orderBy('Identificacao_Log_EGR','desc')

      const {registros} = paginationRecords(periodos, pagina, limite)

      const periodosLimite = await database('pagamentos')
      .distinct("Identificacao_Log_EGR AS periodo")
      .sum("montante_da_operacao AS somatorio")
      .sum("tarifa_aplicada_a_operacao AS tarifa_somada")
      .count("id_pagamento AS quantidade")   
      .max("data_movimento AS data_periodo")
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("data_movimento",`%${data}%`)
      .where({numero_entidade: entidade})
      .limit(registros.limite)
      .offset(registros.count)
      .groupBy(['Identificacao_Log_EGR'])
      .orderBy('Identificacao_Log_EGR','desc')
    
      const filtered = periodosFilteres(periodosLimite)
      registros.total_apresentados = periodosLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.referencia = referencia
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.hora = hora
      registros.data = data

      delete registros.count

      logger("SERVIDOR:getPagamentos").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros,
        url: req.originalUrl
      });
          
      return rs
    
   } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getPagamentos").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getPeriodosEntidade = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data, req){
  try{

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

      if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
        const rs = response("erro", 423, "Serviço de pagamento inactivo");
        return rs    
      }

      logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
      const periodos = await database('pagamentos')
      .distinct("Identificacao_Log_EGR AS periodo")
      .sum("montante_da_operacao AS somatorio")
      .sum("tarifa_aplicada_a_operacao AS tarifa_somada")
      .count("id_pagamento AS quantidade")
      .max("data_movimento AS data_periodo") 
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("data_movimento",`%${data}%`)
      .where({numero_entidade: entidade})
      .limit(total_registros || pagination.total_limite)
      .groupBy(['Identificacao_Log_EGR',"data_movimento"])
      .orderBy('Identificacao_Log_EGR','desc')
      .orderBy('data_periodo','desc')

      const {registros} = paginationRecords(periodos, pagina, limite)

      const periodosLimite = await database('pagamentos')
      .distinct("Identificacao_Log_EGR AS periodo")
      .sum("montante_da_operacao AS somatorio")
      .sum("tarifa_aplicada_a_operacao AS tarifa_somada")
      .count("id_pagamento AS quantidade")
      .max("data_movimento AS data_periodo")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("referencia_do_servico",`%${referencia}%`)
      .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("data_movimento",`%${data}%`)
      .where({numero_entidade: entidade})
      .limit(registros.limite)
      .offset(registros.count)
      .groupBy(['Identificacao_Log_EGR',"data_movimento"])
      .orderBy('Identificacao_Log_EGR','desc')
      .orderBy('data_periodo','desc')
    
      const filtered = periodosFilteres(periodosLimite)
      registros.total_apresentados = periodosLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.referencia = referencia
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.hora = hora
      registros.data = data

      delete registros.count

      logger("SERVIDOR:getPagamentos").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros,
        url: req.originalUrl
      });         
          
      return rs
    
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getPagamentos").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getPeriodosPeriodo = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{

        const periodos = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")  
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .where({Identificacao_Log_EGR:periodo})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
                
        const {registros} = paginationRecords(periodos, pagina, limite)

        const periodosLimite = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")  
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .where({Identificacao_Log_EGR:periodo})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
        
        const [filtered] = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs 
      
     } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPeriodosContabilidade = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{

        const periodos = await database('pagamentos')
        .distinct("referencia_do_servico")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")  
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .where({Identificacao_Log_EGR:periodo})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['referencia_do_servico'])
        .orderBy('somatorio','desc') 
        .orderBy('quantidade','desc')
                
        const {registros} = paginationRecords(periodos, pagina, limite)

        const periodosLimite = await database('pagamentos')
        .distinct("referencia_do_servico")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .where({Identificacao_Log_EGR:periodo})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['referencia_do_servico'])
        .orderBy('somatorio','desc') 
        .orderBy('quantidade','desc')
        
        const filtered = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs 
      
     } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPeriodosEntidadeContabilidade = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{

        const periodos = await database('pagamentos')
        .distinct("referencia_do_servico")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade") 
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .andWhere({Identificacao_Log_EGR:periodo})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['referencia_do_servico'])
        .orderBy('somatorio','desc') 
        .orderBy('quantidade','desc')
                
        const {registros} = paginationRecords(periodos, pagina, limite)

        const periodosLimite = await database('pagamentos')
        .distinct("referencia_do_servico")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade") 
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .andWhere({Identificacao_Log_EGR:periodo})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['referencia_do_servico'])
        .orderBy('somatorio','desc') 
        .orderBy('quantidade','desc')
        
        const filtered = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs 
      
     } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPeriodosContabilidadeData = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{

        const periodos = await database('pagamentos')
        .distinct("referencia_do_servico")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")   
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .where({data_movimento: data})
        .andWhere({Identificacao_Log_EGR:periodo})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['referencia_do_servico'])
        .orderBy('somatorio','desc') 
        .orderBy('quantidade','desc') 
                
        const {registros} = paginationRecords(periodos, pagina, limite)

        const periodosLimite = await database('pagamentos')
        .distinct("referencia_do_servico")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")    
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .where({data_movimento: data})
        .andWhere({Identificacao_Log_EGR:periodo})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['referencia_do_servico'])
        .orderBy('somatorio','desc') 
        .orderBy('quantidade','desc')
        
        const [filtered] = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs 
      
     } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPeriodosEntidadeContabilidadeData = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{

        const periodos = await database('pagamentos')
        .distinct("referencia_do_servico")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")   
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({data_movimento: data})
        .andWhere({numero_entidade: entidade})
        .andWhere({Identificacao_Log_EGR:periodo})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['referencia_do_servico'])
        .orderBy('somatorio','desc') 
        .orderBy('quantidade','desc') 
                
        const {registros} = paginationRecords(periodos, pagina, limite)

        const periodosLimite = await database('pagamentos')
        .distinct("referencia_do_servico")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")    
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({data_movimento: data})
        .andWhere({numero_entidade: entidade})
        .andWhere({Identificacao_Log_EGR:periodo})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['referencia_do_servico'])
        .orderBy('somatorio','desc') 
        .orderBy('quantidade','desc')
        
        const [filtered] = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs 
      
     } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPeriodosEntidadePeriodo = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
    try{

        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

        if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
          const rs = response("erro", 423, "Serviço de pagamento inactivo");
          return rs    
        }

        const periodos = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .sum("tarifa_aplicada_a_operacao AS tarifa_somada")
        .count("id_pagamento AS quantidade")   
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .andWhere({Identificacao_Log_EGR:periodo})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
                
        const {registros} = paginationRecords(periodos, pagina, limite)

        const periodosLimite = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .sum("tarifa_aplicada_a_operacao AS tarifa_somada")
        .count("id_pagamento AS quantidade")    
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .andWhere({Identificacao_Log_EGR:periodo})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
        
        const [filtered] = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs 
    
  } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getPeriodosReferencia = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{
      
        const periodos = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")   
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({referencia_do_servico: referencia})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
                
        const {registros} = paginationRecords(periodos, pagina, limite)

        const periodosLimite = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")    
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({referencia_do_servico: referencia})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
        
        const filtered = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs     
      
      
     } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPeriodosEntidadeReferencia = async function(pagina, limite, total_registros, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{

        const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

        if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
          const rs = response("erro", 423, "Serviço de pagamento inactivo");
          return rs    
        }
      
        const periodos = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")  
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${data}%`)
        .whereLike("data_movimento",`%${hora}%`)
        .where({numero_entidade: entidade})
        .andWhere({referencia_do_servico:referencia})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
                
        const {registros} = paginationRecords(periodos, pagina, limite)

        const periodosLimite = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .max("data_movimento AS data_periodo")    
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .andWhere({referencia_do_servico:referencia})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
        
        const filtered = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs 
      
      
     } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
    }
    
}

module.exports.getPeriodosPesquisar = async function(pagina, limite, total_registros, dia_inicio, dia_final, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{
      
        logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
        const periodos = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .max("data_movimento AS data_periodo") 
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .limit(total_registros || pagination.total_limite)
        .groupBy(['Identificacao_Log_EGR',"data_movimento"])
        .orderBy('Identificacao_Log_EGR','desc')
        .orderBy('data_periodo','desc')
        
        const {registros} = paginationRecords(periodos, pagina, limite)

        logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
        const periodosLimite = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .max("data_movimento AS data_periodo") 
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['Identificacao_Log_EGR',"data_movimento"])
        .orderBy('Identificacao_Log_EGR','desc')
        .orderBy('data_periodo','desc')
        
        const filtered = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        delete registros.count

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs     
      
      
     } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPeriodosPesquisarMesclados = async function(pagina, limite, total_registros, dia_inicio, dia_final, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{
      
        logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
        const periodos = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade") 
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .limit(total_registros || pagination.total_limite)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
        
        const {registros} = paginationRecords(periodos, pagina, limite)

        logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
        const periodosLimite = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .whereLike("numero_entidade",`%${entidade}%`)
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
        
        const filtered = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        delete registros.count

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs     
      
      
     } catch (error) {
        console.error(error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPeriodosEntidadePesquisar = async function(pagina, limite, total_registros, dia_inicio, dia_final, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

      if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
        const rs = response("erro", 423, "Serviço de pagamento inactivo");
        return rs    
      }
      
      logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
        const periodos = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .max("data_movimento AS data_periodo") 
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['Identificacao_Log_EGR',"data_movimento"])
        .orderBy('Identificacao_Log_EGR','desc')
        .orderBy('data_periodo','desc')
        
        const {registros} = paginationRecords(periodos, pagina, limite)

        logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
        const periodosLimite = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .max("data_movimento AS data_periodo") 
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['Identificacao_Log_EGR',"data_movimento"])
        .orderBy('Identificacao_Log_EGR','desc')
        .orderBy('data_periodo','desc')
        
        const filtered = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        delete registros.count

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs   

      
     } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
    }
    
}

module.exports.getPeriodosEntidadePesquisarMesclados = async function(pagina, limite, total_registros, dia_inicio, dia_final, entidade,  montante, tarifa, referencia, periodo, log_transacao, terminal, hora, data) {
     
     try{

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

      if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
        const rs = response("erro", 423, "Serviço de pagamento inactivo");
        return rs    
      }
      
      logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
        const periodos = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .limit(total_registros || pagination.total_limite)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
        
        const {registros} = paginationRecords(periodos, pagina, limite)

        logger("SERVIDOR:getPagamentos").debug("Á carregar dados")
        const periodosLimite = await database('pagamentos')
        .distinct("Identificacao_Log_EGR")
        .sum("montante_da_operacao AS somatorio")
        .count("id_pagamento AS quantidade")
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("referencia_do_servico",`%${referencia}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("data_movimento",`%${data}%`)
        .where({numero_entidade: entidade})
        .limit(registros.limite)
        .offset(registros.count)
        .groupBy(['Identificacao_Log_EGR'])
        .orderBy('Identificacao_Log_EGR','desc')
        
        const filtered = periodosFilteres(periodosLimite)
        registros.total_apresentados = periodosLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.referencia = referencia
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.hora = hora
        registros.data = data

        delete registros.count

        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs   

      
     } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
    }
    
}