const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords");
const { posFilteres } = require('../helpers/filterResponseSQL');

module.exports.getPOS = async function (pagina, limite, total_registros, entidade, pos_nome, pos_codigo_emis, comerciante_id, pos_uuid, activo, ative_status, status_pos, nome_empresa, email) {
  try {

      const gpo_terminais_pos = await database("gpo_terminais_pos")
      .join("clientes","clientes.gpo_comerciante_hash","=","gpo_terminais_pos.comerciante_id")
      .whereLike("numero_entidade",`%${entidade}%`)
      .whereLike("pos_nome",`%${pos_nome}%`)
      .whereLike("pos_codigo_emis",`%${pos_codigo_emis}%`)
      .whereLike("comerciante_id",`%${comerciante_id}%`)
      .whereLike("pos_uuid",`%${pos_uuid}%`)
      .whereLike("activo",`%${activo}%`)
      .whereLike("ative_status",`%${ative_status}%`)
      .whereLike("status_pos",`%${status_pos}%`)
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .whereLike("email",`%${email}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("gpo_terminais_pos_id","desc")

      const {registros} = paginationRecords(gpo_terminais_pos, pagina, limite)

      const gpo_terminais_posLimite = await database("gpo_terminais_pos")
      .join("clientes","clientes.gpo_comerciante_hash","=","gpo_terminais_pos.comerciante_id")
      .whereLike("numero_entidade",`%${entidade}%`)
      .whereLike("pos_nome",`%${pos_nome}%`)
      .whereLike("pos_codigo_emis",`%${pos_codigo_emis}%`)
      .whereLike("comerciante_id",`%${comerciante_id}%`)
      .whereLike("pos_uuid",`%${pos_uuid}%`)
      .whereLike("activo",`%${activo}%`)
      .whereLike("ative_status",`%${ative_status}%`)
      .whereLike("status_pos",`%${status_pos}%`)
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .whereLike("email",`%${email}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy("gpo_terminais_pos_id","desc")

      const filtered = posFilteres(gpo_terminais_posLimite)

      registros.total_apresentados = gpo_terminais_posLimite.length
      registros.entidade = entidade
      registros.pos_nome = pos_nome
      registros.pos_codigo_emis = pos_codigo_emis
      registros.comerciante_id = comerciante_id
      registros.pos_uuid = pos_uuid
      registros.activo = activo
      registros.ative_status = ative_status
      registros.status_pos = status_pos
      registros.nome_empresa = nome_empresa
      registros.email = email
    
      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered, 'json', {registros});          
      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getPOSID = async function (gpo_terminais_pos_id) {
 
  try {

      const gpo_terminais_pos = await database("gpo_terminais_pos")
      .join("clientes", "clientes.gpo_comerciante_hash", "=", "gpo_terminais_pos.comerciante_id")
      .where({ gpo_terminais_pos_id });

      const filtered = posFilteres(gpo_terminais_pos)      

      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered);          
      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getPOSComerciante = async function (comerciante_id) {  

  try {
      
      const gpo_terminais_pos = await database("gpo_terminais_pos")
      .join("clientes", "clientes.gpo_comerciante_hash", "=", "gpo_terminais_pos.comerciante_id" )
      .where({ comerciante_id });
      
      const filtered = posFilteres(gpo_terminais_pos)      

      logger("SERVIDOR:getPercentualUsoEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered);          
      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.postPOS = async function (dados) {
  try {


      const resultEnt = await database("gpo_terminais_pos")
      .where({ comerciante_id: dados.comerciante_id })
      .andWhere({ pos_codigo_emis: dados.pos_codigo_emis });

      const resultEntVezes = await database("gpo_terminais_pos")
      .where({ comerciante_id: dados.comerciante_id })

      const resultPOSs = await database("clientes")
      .where({ gpo_comerciante_hash: dados.comerciante_id });
      
      if (resultEnt.length > 0){
        logger("SERVIDOR:postClientes").info(`Esta entidade já o POS ${dados.pos_codigo_emis} configurado!`)
        const rs = response("erro", 409, `Esta entidade já o POS ${dados.pos_codigo_emis} configurado!`);
        return rs
      }

      if (Number(resultPOSs[0].gpo_numero_POS) <= resultEntVezes.length){
        logger("SERVIDOR:postClientes").info(`Esta entidade já possui o número de POS configurados!`)
        const rs = response("erro", 409, `Esta entidade já possui o número de POS configurados!`);
        return rs
      }

    
      logger("SERVIDOR:Clientes").debug(`A cadastrar o cliente`) 
      await database("gpo_terminais_pos").insert(dados); 

      logger("SERVIDOR:Clientes").info("Parametrização feita com sucesso")
      const rs = response("sucesso", 201, "Parametrização feita com sucesso");
    
      return rs

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }   
  }
};

module.exports.patchPOS = async function (gpo_terminais_pos_id, dados) {
  try {

      const POSVerify = await database('gpo_terminais_pos').where({pos_codigo_emis: dados?.pos_codigo_emis}).orWhere({comerciante_id: gpo_terminais_pos_id})

      if(POSVerify.length){
        gpo_terminais_pos_id = POSVerify[0].gpo_terminais_pos_id
      }

      if(dados?.status_pos){
        dados.ative_status = dados?.status_pos == "OPEN" ? "true" : "false"
      }

      await database("gpo_terminais_pos")
      .where({ gpo_terminais_pos_id }) 
      .update(dados);

      logger("SERVIDOR:patchClientes").info(`Cliente actualizado com sucesso`)
      const rs = response("sucesso", 202, "Actualização feita com sucesso");
      return rs

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
};

module.exports.deletePOS = async function (gpo_terminais_pos_id) {
  try {
      const pos = await database("gpo_terminais_pos")
      .where({ gpo_terminais_pos_id })
      
      if(!pos.length){
        logger("SERVIDOR:postClientes").info(`Esta entidade já o POS ${dados.pos_codigo_emis} configurado!`)
        const rs = response("erro", 409, `Esta entidade já o POS ${dados.pos_codigo_emis} configurado!`);
        return rs
      }

      await database("gpo_terminais_pos")
      .where({ gpo_terminais_pos_id })
      .del();

      return {
        status: "sucesso",
        mensagem: "Parametrização excluida feita com sucesso"
      };
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:getPercentualUsoEntidade").error(`Erro ao buscar o percentual ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
