const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords")
const { produtosClientesFilteres } = require('../helpers/filterResponseSQL');

module.exports.getTipo_produto = async function (pagina, limite, total_registros, nome_empresa, nif, email, numero_entidade, responsavel) {
  try {
      const produtos_clientes = await database("produtos_clientes")
      .join("tipo_produto_cliente", "tipo_produto_cliente.id_tipo_produto_clientes", "=", "produtos_clientes.cliente_tipo_produto")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo" )
      .whereLike("nome_empresa",`%${String(nome_empresa).toUpperCase()}%`)
      .whereLike("nif",`%${nif}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("responsavel",`%${responsavel}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_produto", "DESC");      

      const {registros} = paginationRecords(produtos_clientes, pagina, limite)

      const produtos_clientesLimite = await database("produtos_clientes")
      .join("tipo_produto_cliente", "tipo_produto_cliente.id_tipo_produto_clientes", "=", "produtos_clientes.cliente_tipo_produto")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo" )
      .whereLike("nome_empresa",`%${String(nome_empresa).toUpperCase()}%`)
      .whereLike("nif",`%${nif}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("responsavel",`%${responsavel}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy("id_produto", "DESC");

      const filtered = produtosClientesFilteres(produtos_clientesLimite)

      registros.total_apresentados = produtos_clientesLimite.length
      registros.nome_empresa = nome_empresa
      registros.nif = nif
      registros.email = email
      registros.numero_entidade = numero_entidade
      registros.responsavel = responsavel

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered, "json", { registros });
      return rs

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTipo_produtoID = async function (id_produto) {
  try {
      const produtos_clientes = await database("produtos_clientes")
      .join("tipo_produto_cliente", "tipo_produto_cliente.id_tipo_produto_clientes", "=", "produtos_clientes.cliente_tipo_produto")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo" )
      .orderBy("id_produto", "DESC")
      .where({ id_produto });

      const filtered = produtosClientesFilteres(produtos_clientes)

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered);
      return rs

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTipo_produtoEntidadeTipo = async function (cliente_tipo_produto) {
  try {
      const produtos_clientes = await database("produtos_clientes")
      .join("tipo_produto_cliente", "tipo_produto_cliente.id_tipo_produto_clientes", "=", "produtos_clientes.cliente_tipo_produto")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo" )
      .orderBy("id_produto", "DESC")
      .where({ cliente_tipo_produto });

      const filtered = produtosClientesFilteres(produtos_clientes)

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered);
      return rs    
      
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTipo_produtoEntidade = async function (cliente) {
  try {
      const produtos_clientes = await database("produtos_clientes")
      .join("tipo_produto_cliente", "tipo_produto_cliente.id_tipo_produto_clientes", "=", "produtos_clientes.cliente_tipo_produto")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo" )
      .orderBy("id_produto", "DESC")
      .where({ numero_entidade: cliente });

      const filtered = produtosClientesFilteres(produtos_clientes)

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered);
      return rs 

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.postTipo_produto = async function (dados) {
  try {
      const resultTipoReg = await database("tipo_produto_cliente")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo")
      .where({ id_tipo_produto_clientes: dados.cliente_tipo_produto });

      if (!resultTipoReg.length){
        logger("SERVIDOR:postAfiliados").info("Não foi parametrizado o tipo de registo para inserção do seu produtos!")
        const rs = response("erro", 406, "Não foi parametrizado o tipo de registo para inserção do seu produtos!");
        return rs
      }

      const resultCodigoProduto = await database("produtos_clientes")
      .where({ codigo_do_produto: dados.codigo_do_produto })
      .andWhere({ cliente_tipo_produto: dados.cliente_tipo_produto });

      if (resultCodigoProduto.length > 0){
        logger("SERVIDOR:postAfiliados").info("Produto ou codigo do produto já parametrizado!")
        const rs = response("erro", 406, "Produto ou codigo do produto já parametrizado!");
        return rs
      }

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      await database("produtos_clientes").insert(dados);

      logger("SERVIDOR:postAfiliados").info("Parametrização feita com sucesso");
      const rs = response("sucesso", 201, "Parametrização feita com sucesso");
      return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.patchTipo_produto = async function (id_produto, dados) {
  try {
      const resultProduto = await database("produtos_clientes").where({ id_produto });

      if (!resultProduto.length){
        logger("SERVIDOR:postAfiliados").info("Produto do cliente não encontrado!")
        const rs = response("erro", 409, "Produto do cliente não encontrado!");
        return rs
      }

      await database("produtos_clientes").where({ id_produto }).update(dados);
      
      logger("SERVIDOR:postAfiliados").info("Actualização feita com sucesso");
      const rs = response("sucesso", 202, "Actualização feita com sucesso");
      return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteTipo_produto = async function (id_produto) {
  try {
      const resultProduto = await database("produtos_clientes").where({ id_produto });

      if (!resultProduto.length){
        logger("SERVIDOR:postAfiliados").info("Produto do cliente não encontrado!")
        const rs = response("erro", 409, "Produto do cliente não encontrado!");
        return rs
      }

      await database("produtos_clientes").where({ id_produto }).del();

      logger("SERVIDOR:postAfiliados").info("Exclusão feita com sucesso");
      const rs = response("sucesso", 202, "Exclusão feita com sucesso");
      return rs;
      
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
