const database = require('../config/database')
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { produtosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getFixos = async function(pagina, limite, total_registros, entidade, descricao, montante_fixo) { 
  try {
      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const fixos = await database('valores_fixos')
      .whereLike("entidade_produdo",`%${entidade}%`)
      .whereLike("descricao",`%${descricao}%`)
      .whereLike("montante_fixo",`%${montante_fixo}%`)
      .limit(total_registros || pagination.total_limite)  
      .orderBy('id_fixo','DESC')

      const {registros} = paginationRecords(fixos, pagina, limite)

      logger("SERVIDOR:getAfiliados").debug(`Buscar todos afiliados no banco de dados com limite de ${registros.limite} na pagina ${registros.count} de registros`);
      const fixosLimite =await database('valores_fixos')
      .whereLike("entidade_produdo",`%${entidade}%`)
      .whereLike("descricao",`%${descricao}%`)
      .whereLike("montante_fixo",`%${montante_fixo}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy("id_fixo", "DESC");

      const filtered = produtosFilteres(fixosLimite)

      registros.total_apresentados = fixosLimite.length
      registros.entidade = entidade
      registros.descricao = descricao
      registros.montante_fixo = montante_fixo

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;
    
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFixosID = async function(id_fixo) {
  try {
      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const fixos = await database('valores_fixos')
      .where({id_fixo})
      
      const [filtered] = produtosFilteres(fixos)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;
    
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getFixosEntidades = async function(entidade_produdo) {
  try {
      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const fixos = await database('valores_fixos')
      .where({entidade_produdo})
      
      const filtered = produtosFilteres(fixos)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered)
      return rs;
    
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.postFixos = async function(dados) {
  
  try {    
    
    const verificarNome = await database('valores_fixos').where({entidade_produdo: dados.entidade_produdo}).andWhere({descricao: dados.descricao});
    const verificarQuantidade = await database('valores_fixos').where({entidade_produdo: dados.entidade_produdo});

    if(verificarNome.length > 0){
      return {status:"erro", mensagem: "Descrição do valor fixo existente!"}
    }

    if(verificarQuantidade.length > 8){
      return {status:"erro", mensagem: "Ocorrencia de valores fixo esgotado para o produto!"}
    }

    await database('valores_fixos').insert(dados)                   
    
    return {status:"sucesso", mensagem:"Gravado com sucesso"}
    
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.patchFixos = async function(id_fixo, dados) {
  try {

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const resultFixo = await database("valores_fixos")
      .where({id_fixo});

      if (!resultFixo.length){
        logger("SERVIDOR:postAfiliados").info("Registro inexistente")
        const rs = response("erro", 409, "Registro inexistente");
        return rs
      }
  
      logger("SERVIDOR:postAfiliados").info("Registro inexistente")
      await database("valores_fixos")
      .where({id_fixo})
      .update(dados)
     
     return {status: "sucesso", mensagem: "Valor fixo actualizada com sucesso"}
   
   } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
   }
    
}

module.exports.deleteFixos = async function(id_fixo) {
  
  try {
  
      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const resultFixo = await database("valores_fixos")
      .where({id_fixo});

      if (!resultFixo.length){
        logger("SERVIDOR:postAfiliados").info("Registro inexistente")
        const rs = response("erro", 409, "Registro inexistente");
        return rs
      }
      
      logger("SERVIDOR:postAfiliados").info("Registro inexistente")
      await database("valores_fixos")
      .where({id_fixo})
      .del()
     
     return {status: "sucesso", mensagem: "Valor fixo excluido com sucesso"}
   
   } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
   }
    
}