const database = require('../config/database')

module.exports.getLogReqRetry = async function(req, res, next) {
  try {
    const logsReq = await database("retry_automatico_requisicoes")
    .join("webhooks_logs","webhooks_logs.id_logreq","=","retry_automatico_requisicoes.log_enviado") 
    .join("webhooks_endpoints","webhooks_endpoints.id_endpoint","=","webhooks_logs.endpoint")
    .orderBy('id_automatico_requisicoes','DESC')
    
    return {status:"sucesso", mensagem: logsReq}
    
  } catch (error) {
    console.log(error)
    return {status:"erro", mensagem: "Aconteceu algo. Tente de novo"}
  }
    
}

module.exports.getLogReqIDRetry = async function(id_automatico_requisicoes) {
  try {
    const logsReq = await database("retry_automatico_requisicoes")
    .join("webhooks_logs","webhooks_logs.id_logreq","=","retry_automatico_requisicoes.log_enviado") 
    .join("webhooks_endpoints","webhooks_endpoints.id_endpoint","=","webhooks_logs.endpoint")
    .where({id_automatico_requisicoes})
    .orderBy('id_logreq','DESC')
    
    return {status:"sucesso", mensagem: logsReq}
    
  } catch (error) {
    console.log(error)
    return {status:"erro", mensagem: "Aconteceu algo. Tente de novo"}
  }
    
}

module.exports.getLogReqEntidadeRetry = async function(entidade_aceite) {
  try {

    const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade_aceite})        

       if((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false")){
        return {status:"erro", mensagem:"Serviço de pagamento por sector invativo"}      
      }

    const logsReq = await database("retry_automatico_requisicoes")
    .join("webhooks_logs","webhooks_logs.id_logreq","=","retry_automatico_requisicoes.log_enviado") 
    .join("webhooks_endpoints","webhooks_endpoints.id_endpoint","=","webhooks_logs.endpoint")
    .where({entidade_aceite})
    .orderBy('id_automatico_requisicoes','DESC')
    
    return {status:"sucesso", mensagem: logsReq}
    
  } catch (error) {
    console.log(error)
    return {status:"erro", mensagem: "Aconteceu algo. Tente de novo"}
  }
    
}

