const database = require('../config/database')
const path = require("path");
const response = require("../constants/response");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords")
require("dotenv").config({ path: path.resolve(path.join(__dirname,'../','.env')) });


module.exports.getClintesSMSEntidadeGET = async function(entidade, pagina, limite, mensagem, req) {

  try {

      logger("SERVIDOR:ClintesSMSEntidadeGET").debug(`Buscar configuração de sms de cliente`)
      const envio_mensagens = await database('envio_mensagens_clientes')
      .join('envio_remetentes',"envio_remetentes.id_envio_rementente","=","envio_mensagens_clientes.id_envio_rementente_entidade")
      .whereLike("mensagem_envio",`%${mensagem}%`)
      .where("entidade_remetente",entidade)
      .orderBy('id_envio','DESC')

      const {registros} = paginationRecords(envio_mensagens, pagina, limite)

      const envio_mensagensLimite  = await database('envio_mensagens_clientes')
      .join('envio_remetentes',"envio_remetentes.id_envio_rementente","=","envio_mensagens_clientes.id_envio_rementente_entidade")
      .whereLike("mensagem_envio",`%${mensagem}%`)
      .where("entidade_remetente",entidade)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_envio','DESC')

      logger("SERVIDOR:ClintesSMSEntidadeGET").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, envio_mensagensLimite, "json", { registros }); 
      return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:ClintesSMSEntidadeGET").error(`Erro ao buscar clientes ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
  
}

module.exports.getClintesSMSGET = async function(pagina, limite, mensagem, req) {

  try {

      logger("SERVIDOR:ClintesSMSGET").debug(`Recuperando da base de dados`)
      const envio_mensagens = await database('envio_mensagens_clientes')
      .whereLike("mensagem_envio",`%${mensagem}%`)
      .orderBy('id_envio','DESC')

      const {registros} = paginationRecords(envio_mensagens, pagina, limite)

      const envio_mensagensLimite  = await database('envio_mensagens_clientes')
      .whereLike("mensagem_envio",`%${mensagem}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_envio','DESC')

      logger("SERVIDOR:ClintesSMSGET").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, envio_mensagensLimite, "json", { registros }); 
      return rs
    
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:ClintesSMSGET").error(`Erro ao buscar clientes ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
  
}

module.exports.getClintesSMSEntidade = async function(entidade, pagina, limite, req) {

  try {

    logger("SERVIDOR:ClintesSMSEntidade").debug(`Buscar configuração de sms de cliente`)
    const resultEnt  = await database('envio_config_mensagem').where({env_entidade: entidade})
    
    logger("SERVIDOR:ClintesSMSEntidade").info("Respondeu a solicitação")
    const rs = response("sucesso", 200, resultEnt, "json");          
    return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:ClintesSMSEntidade").error(`Erro ao buscar configuarções sms de cliente ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
  
}

module.exports.getClintesSMS = async function(pagina, limite, req) {

  try {

    logger("SERVIDOR:ClintesSMS").debug("Buscar as configuarções de sms")
    const envidoConfMensagens  = await database('envio_config_mensagem')
    .orderBy('id_envio_config', 'DESC')

    const {registros} = paginationRecords(envidoConfMensagens, pagina, limite)

    const envidoConfMensagensLimite = await database('envio_config_mensagem')
    .limit(registros.limite)
    .offset(registros.count)
    .orderBy('id_envio_config','DESC')
    
    logger("SERVIDOR:ClintesSMS").info("Respondeu a solicitação")

    const rs = response("sucesso", 200, envidoConfMensagensLimite, "json", { registros });   
    return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:ClintesSMS").error(`Erro ao buscar as configuracoes ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
  
}

module.exports.smsRemententeEntidade = async function(entidade, req) {

  try {

    logger("SERVIDOR:smsRemententeEntidade").debug("Verificar se existencia do remetente")
    const resultEnt  = await database('envio_remetentes').where({entidade_remetente: entidade})
    
    logger("SERVIDOR:smsRemententeEntidade").info("Respondeu a solicitação")
    if(!resultEnt.length){
      const rs = response("sucesso", 204, []);          
      return rs
    }
    
    const rs = response("sucesso", 200, resultEnt[0]);          
    return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:smsRemententeEntidade").error(`Erro ao buscar remetente ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
  
}

module.exports.StatusRemetentes = async function(id_api_rementente) {

  try {

    logger("SERVIDOR:smsRemententes").debug("Verificar se existencia da api do remetente")
    const resultEnt  = await database('envio_remetentes').where({id_api_rementente: id_api_rementente}) 
    
    logger("SERVIDOR:smsRemententes").info("Respondeu a solicitação")
    const rs = response("sucesso", 200, resultEnt);          
    return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:smsRemententes").error(`Erro ao buscar remetente ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
  
}

module.exports.updateStatusRemetente = async function(id, status, req) {

  try {
    logger("SERVIDOR:smsRemententeID").debug("Verificar se existencia da api do remetente")
    const resultEnt  = await database('envio_remetentes').where({id_api_rementente: id})

    if(!resultEnt.length) {
      const rs = response("erro", 409, 'Seu remetente não foi gerado!');          
      return rs
    }
    

    logger("SERVIDOR:smsRemententeID").debug("Actualizar o status remetente")
    await database('envio_remetentes').where({id_api_rementente: id}).update({estado_remetente: status})

    logger("SERVIDOR:smsRemententeID").debug("Verificar se existencia da api do remetente")
    const resultEntUpdated  = await database('envio_remetentes').where({id_api_rementente: id})

    logger("SERVIDOR:smsRemententeID").info("Respondeu a solicitação")
    if(resultEntUpdated.length){

      const rs = response("sucesso", 202, resultEntUpdated[0]);          
      return rs

    }

    const rs = response("sucesso", 202, resultEntUpdated);          
    return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:smsRemententeID").error(`Erro ao buscar rementente pelo ID ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');  
    return rs
  }
  
}

module.exports.postClientesSMS = async function(mensagem, env_entidade, tipo_env, req) {

  try {

    logger("SERVIDOR:ClientesSMS").debug("Verificar se existencia do tipo de envio para o template")
    const resultEnt  = await database('envio_config_mensagem').where({env_entidade}).andWhere({tipo_env})
    
    if(resultEnt.length){
      logger("SERVIDOR:ClientesSMS").debug("Actualizar a mensagem do template")
      await database('envio_config_mensagem').where({env_entidade}).andWhere({tipo_env}).update({mensagem})

      logger("SERVIDOR:ClientesSMS").info("Template de sms actualizada")
      const rs = response("sucesso", 202, "Template de sms actualizada");          
      return rs
    }

    logger("SERVIDOR:ClientesSMS").debug("Gravar a mensagem do template")
    await database('envio_config_mensagem').insert({mensagem, env_entidade, tipo_env})

    logger("SERVIDOR:ClientesSMS").info("Template de sms gravado com sucesso")
    const rs = response("sucesso", 201, "Template de sms gravado com sucesso");          
    return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:ClientesSMS").error(`Erro ao cadastrar o template de sms ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
  
} 

module.exports.smsRemetentes = async function(dados, req) {

  try {

    logger("SERVIDOR:smsRementente").debug(`Busca de existencia do remetente`)
    const resultEnt  = await database('envio_remetentes').where({entidade_remetente: dados.entidade_remetente})

    if(resultEnt.length > 0) {
      logger("SERVIDOR:smsRementente").info(`Nome de rementente já gravado!`)
      const rs = response("erro", 409, 'Nome de rementente já gravado!');          
      return rs
    }

    logger("SERVIDOR:smsRementente").debug(`Gravar na base de dados`)
    await database('envio_remetentes').insert(dados)

    logger("SERVIDOR:smsRementente").info(`Remetente gravado! Aguarde aprovação`)
    const rs = response("sucesso", 201, "Remetente gravado! Aguarde aprovação");          
    return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:smsRemetentes").error(`Erro ao inserir remetente ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
  
}

