const database = require('../config/database')
const response = require("../constants/response");
const logger = require('../services/loggerService');
module.exports.getTipo_produto = async function () {
  try {
      const tipo_produtos = await database("tipo_produto")
      .orderBy("id_tipo_produto", "DESC");

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, tipo_produtos);
      return rs

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.patchTipo_produto = async function (id_tipo_produto, dados) {
  try {

      const resultProduto = await database("tipo_produto").where({ id_tipo_produto });

      if (!resultProduto.length){
        logger("SERVIDOR:postAfiliados").info("Produto não encontrado!")
        const rs = response("erro", 409, "Produto não encontrado!");
        return rs
      }

      await database("tipo_produto").where({ id_tipo_produto }).update(dados);
      
      logger("SERVIDOR:postAfiliados").info("Actualização feita com sucesso");
      const rs = response("sucesso", 202, "Actualização feita com sucesso");
      return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
