const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords")
const { tipoProdutosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getTipo_produto = async function (pagina, limite, total_registros, nome_empresa, nif, email, numero_entidade, responsavel) {
  try {
      const produtos_clientes = await database("produtos_clientes")
      .join("tipo_produto_cliente", "tipo_produto_cliente.id_tipo_produto_clientes", "=", "produtos_clientes.cliente_tipo_produto")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo" )
      .whereLike("nome_empresa",`%${String(nome_empresa).toUpperCase()}%`)
      .whereLike("nif",`%${nif}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("responsavel",`%${responsavel}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_produto", "DESC");      

      const {registros} = paginationRecords(produtos_clientes, pagina, limite)

      const produtos_clientesLimite = await database("produtos_clientes")
      .join("tipo_produto_cliente", "tipo_produto_cliente.id_tipo_produto_clientes", "=", "produtos_clientes.cliente_tipo_produto")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo" )
      .whereLike("nome_empresa",`%${String(nome_empresa).toUpperCase()}%`)
      .whereLike("nif",`%${nif}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("numero_entidade",`%${numero_entidade}%`)
      .whereLike("responsavel",`%${responsavel}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy("id_produto", "DESC");

      const filtered = tipoProdutosFilteres(produtos_clientesLimite)

      registros.total_apresentados = produtos_clientesLimite.length
      registros.nome_empresa = nome_empresa
      registros.nif = nif
      registros.email = email
      registros.numero_entidade = numero_entidade
      registros.responsavel = responsavel

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered, "json", { registros });
      return rs

  } catch (error) {
    console.log(error);
    return { status: "erro", mensagem: "Algo aconteceu. Tente de novo!" };
  }
};

module.exports.getTipo_produtoID = async function (id_produto) {
  try {
      const produtos_clientes = await database("produtos_clientes")
      .join("tipo_produto_cliente", "tipo_produto_cliente.id_tipo_produto_clientes", "=", "produtos_clientes.cliente_tipo_produto")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo" )
      .orderBy("id_produto", "DESC")
      .where({ id_produto });

      const filtered = tipoProdutosFilteres(produtos_clientes)

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered);
      return rs

  } catch (error) {
    console.log(error);
    return { status: "erro", mensagem: "Algo aconteceu. Tente de novo!" };
  }
};

module.exports.getTipo_produtoEntidadeTipo = async function (
  cliente_tipo_produto
) {
  try {
    const produtos_clientes = await database("produtos_clientes")
      .join(
        "tipo_produto_cliente",
        "tipo_produto_cliente.id_tipo_produto_clientes",
        "=",
        "produtos_clientes.cliente_tipo_produto"
      )
      .join(
        "clientes",
        "clientes.id_clientes",
        "=",
        "tipo_produto_cliente.cliente"
      )
      .join(
        "tipo_produto",
        "tipo_produto.id_tipo_produto",
        "=",
        "tipo_produto_cliente.tipo_registo"
      )
      .orderBy("id_produto", "DESC")
      .where({ cliente_tipo_produto });

    const clientes = await database("clientes")
      .join(
        "tipo_produto_cliente",
        "clientes.id_clientes",
        "=",
        "tipo_produto_cliente.cliente"
      )
      .join(
        "produtos_clientes",
        "tipo_produto_cliente.id_tipo_produto_clientes",
        "=",
        "produtos_clientes.cliente_tipo_produto"
      )
      .where({ cliente_tipo_produto });

    const dados = [];
    for (const iterator of clientes) {
      const registo = [];
      delete iterator.senha;
      delete iterator.tipo_produto;
      delete iterator.tipo_registo;
      // delete iterator.nome_empresa;
      delete iterator.nif;
      delete iterator.contacto;
      delete iterator.email;
      delete iterator.criando_em;
      delete iterator.feito_em;
      delete iterator.logo;
      delete iterator.id_tipo_produto_clientes;
      delete iterator.cliente;
      delete iterator.id_produto;
      delete iterator.cliente_tipo_produto;
      delete iterator.criado_quando;
      delete iterator.produto;
      for (const i of produtos_clientes) {
        if (iterator.id_clientes == i.cliente) {
          registo.push(i);
          delete i.senha;
          delete i.cliente;
          delete i.tipo_registo;
          delete i.id_clientes;
          delete i.nome_empresa;
          delete i.nif;
          delete i.contacto;
          delete i.email;
          // delete i.id_tipo_produto;
          delete i.criando_em;
          delete i.feito_em;
          delete i.tipo_produto;
          delete i.logo;
          // delete i.numero_entidade;
          delete i.comunicacao;
          delete i.num_padrao_referencias;
          delete i.responsavel;
          delete i.id_tipo_produto_clientes;
          delete i.senha;
        }
      }
      iterator.registo = registo;
      if (iterator.registo.length > 0) dados.push(iterator);
    }

    return { status: "sucesso", mensagem: dados };
  } catch (error) {
    console.log(error);
    return { status: "erro", mensagem: "Algo aconteceu. Tente de novo!" };
  }
};

module.exports.getTipo_produtoEntidade = async function (cliente) {
  try {
    const produtos_clientes = await database("produtos_clientes")
      .join(
        "tipo_produto_cliente",
        "tipo_produto_cliente.id_tipo_produto_clientes",
        "=",
        "produtos_clientes.cliente_tipo_produto"
      )
      .join(
        "clientes",
        "clientes.id_clientes",
        "=",
        "tipo_produto_cliente.cliente"
      )
      .join(
        "tipo_produto",
        "tipo_produto.id_tipo_produto",
        "=",
        "tipo_produto_cliente.tipo_registo"
      )
      .orderBy("id_produto", "DESC")
      .where({ numero_entidade: cliente });

    const clientes = await database("clientes")
      .join(
        "tipo_produto_cliente",
        "clientes.id_clientes",
        "=",
        "tipo_produto_cliente.cliente"
      )
      .join(
        "produtos_clientes",
        "tipo_produto_cliente.id_tipo_produto_clientes",
        "=",
        "produtos_clientes.cliente_tipo_produto"
      )
      .where({ numero_entidade: cliente });

    const dados = [];
    for (const iterator of clientes) {
      const registo = [];
      delete iterator.senha;
      delete iterator.tipo_produto;
      delete iterator.tipo_registo;
      // delete iterator.nome_empresa;
      delete iterator.nif;
      delete iterator.contacto;
      delete iterator.email;
      delete iterator.criando_em;
      delete iterator.feito_em;
      delete iterator.logo;
      // delete iterator.id_tipo_produto_clientes
      delete iterator.cliente;
      delete iterator.id_produto;
      delete iterator.cliente_tipo_produto;
      delete iterator.criado_quando;
      delete iterator.produto;
      for (const i of produtos_clientes) {
        if (iterator.id_clientes == i.cliente) {
          registo.push(i);
          delete i.senha;
          delete i.cliente;
          delete i.tipo_registo;
          delete i.id_clientes;
          delete i.nome_empresa;
          delete i.nif;
          delete i.contacto;
          delete i.email;
          // delete i.id_tipo_produto; 
          delete i.criando_em;
          delete i.feito_em;
          delete i.tipo_produto;
          delete i.logo;
          delete i.numero_entidade;
          delete i.comunicacao;
          delete i.num_padrao_referencias;
          delete i.responsavel;
          delete i.id_tipo_produto_clientes;
          delete i.senha;
        }
      }

      iterator.registo = registo;
      if (iterator.registo.length > 0) dados.push(iterator);
    }

    return { status: "sucesso", mensagem: dados };
  } catch (error) {
    console.log(error);
    return { status: "erro", mensagem: "Algo aconteceu. Tente de novo!" };
  }
};

module.exports.postTipo_produto = async function (dados) {
  try {
    const resultTipoReg = await database("tipo_produto_cliente")
      .join(
        "clientes",
        "clientes.id_clientes",
        "=",
        "tipo_produto_cliente.cliente"
      )
      .join(
        "tipo_produto",
        "tipo_produto.id_tipo_produto",
        "=",
        "tipo_produto_cliente.tipo_registo"
      )
      .where({ id_tipo_produto_clientes: dados.cliente_tipo_produto });

    if (resultTipoReg.length < 1)
      return {
        mensagem:
          "Não foi parametrizado o tipo de registo para inserção do seu produtos!",
        status: "erro"
      };

    const resultCodigoProduto = await database("produtos_clientes")
      .where({ codigo_do_produto: dados.codigo_do_produto })
      .andWhere({ cliente_tipo_produto: dados.cliente_tipo_produto });

    if (resultCodigoProduto.length > 0)
      return {
        mensagem: "Produto ou codigo do produto já parametrizado!",
        status: "erro"
      };

    await database("produtos_clientes").insert(dados);
    return { status: "sucesso", mensagem: "Parametrização feita com sucesso" };
  } catch (error) {
    console.log(error);
    return { status: "error", mensagem: "Algo aconteceu. Tente de novo" };
  }
};

module.exports.patchTipo_produto = async function (id_produto, dados) {
  try {
    await database("produtos_clientes").where({ id_produto }).update(dados);
    return { status: "sucesso", mensagem: "Actualização feita com sucesso" };
  } catch (error) {
    console.log(error);
    return { status: "error", mensagem: "Algo aconteceu. Tente de novo" };
  }
};

module.exports.deleteTipo_produto = async function (id_produto) {
  try {
    await database("produtos_clientes").where({ id_produto }).del();
    return {
      status: "sucesso",
      mensagem: "Parametrização excluida feita com sucesso"
    };
  } catch (error) {
    console.log(error);
    return { status: "error", mensagem: "Algo aconteceu. Tente de novo" };
  }
};
