const database = require('../config/database')
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { produtosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getTipo_produto = async function (pagina, limite, total_registros, nome_empresa, registo_produto, entidade) {
  try {

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const tipoProdutosClientes = await database("tipo_produto_cliente")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo")
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .whereLike("registo_produto",`%${registo_produto}%`)
      .whereLike("numero_entidade",`%${entidade}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_tipo_produto_clientes','DESC')

      const {registros} = paginationRecords(tipoProdutosClientes, pagina, limite)

      logger("SERVIDOR:getAfiliados").debug(`Buscar todos afiliados no banco de dados com limite de ${registros.limite} na pagina ${registros.count} de registros`);
      const tipoProdutosClientesLimite = await database("tipo_produto_cliente")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo")
      .whereLike("nome_empresa",`%${nome_empresa}%`)
      .whereLike("registo_produto",`%${registo_produto}%`)
      .whereLike("numero_entidade",`%${entidade}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy("id_tipo_produto_clientes", "DESC");

      const filtered = produtosFilteres(tipoProdutosClientesLimite)

      registros.total_apresentados = tipoProdutosClientesLimite.length
      registros.nome_empresa = nome_empresa
      registros.registo_produto = registo_produto
      registros.entidade = entidade

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;
      
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTipo_produtoID = async function (id_tipo_produto_clientes) {
 
  try {

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const tipoProdutosClientes = await database("tipo_produto_cliente")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo")
      .where({ id_tipo_produto_clientes })
      .orderBy("id_tipo_produto_clientes", "DESC")

      const [filtered] = produtosFilteres(tipoProdutosClientes)
      

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {});
      return rs;
      
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTipo_produtoCliente = async function (cliente) {

  try {

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const tipoProdutosClientes =await database("tipo_produto_cliente")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo")
      .where({ cliente });

      const filtered = produtosFilteres(tipoProdutosClientes)
      

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered)
      return rs;
      
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTipo_produtoEntidade = async function (cliente) {
  try {

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const tipoProdutosClientes =await database("tipo_produto_cliente")
      .join("clientes", "clientes.id_clientes", "=", "tipo_produto_cliente.cliente")
      .join("tipo_produto", "tipo_produto.id_tipo_produto", "=", "tipo_produto_cliente.tipo_registo")
      .where({ numero_entidade: cliente });

      const filtered = produtosFilteres(tipoProdutosClientes)      

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered)
      return rs;
      
  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.postTipo_produto = async function (dados) {
  try {

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const resultEnt = await database("tipo_produto_cliente")
      .andWhere({ cliente: dados.cliente });

      const resultTipoReg = await database("tipo_produto")
      .where({id_tipo_produto: dados.tipo_registo});

      if (resultTipoReg.length < 1){
        logger("SERVIDOR:postAfiliados").info("Tipo de produto invalido!")
        const rs = response("erro", 409, "Tipo de produto invalido!");
        return rs
      }

      if (resultEnt.length > 0){
        logger("SERVIDOR:postAfiliados").info("Esta entidade já um produto configurado! Deverá fazer adesão de outra entidade para ter outro produto")
        const rs = response("erro", 409, "Esta entidade já um produto configurado! Deverá fazer adesão de outra entidade para ter outro produto");
        return rs
      }

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      await database("tipo_produto_cliente").insert(dados);

      logger("SERVIDOR:postAfiliados").info("Parametrização feita com sucesso");
      const rs = response("sucesso", 201, "Parametrização feita com sucesso");
      return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.patchTipo_produto = async function (id_tipo_produto_clientes, dados) {
  try {

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const resultTipoReg = await database("tipo_produto_cliente")
      .where({id_tipo_produto_clientes});

      if (!resultTipoReg.length){
        logger("SERVIDOR:postAfiliados").info("Registro inexistente")
        const rs = response("erro", 409, "Registro inexistente");
        return rs
      }

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      await database("tipo_produto_cliente")
      .where({ id_tipo_produto_clientes })
      .update(dados);
      
      logger("SERVIDOR:postAfiliados").info("Actualização feita com sucesso");
      const rs = response("sucesso", 202, "Actualização feita com sucesso");
      return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteTipo_produto = async function (id_tipo_produto_clientes) {
  try {

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      const resultTipoReg = await database("tipo_produto_cliente")
      .where({id_tipo_produto_clientes});

      if (!resultTipoReg.length){
        logger("SERVIDOR:postAfiliados").info("Registro inexistente")
        const rs = response("erro", 409, "Registro inexistente");
        return rs
      }

      logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
      await database("tipo_produto_cliente")
      .where({ id_tipo_produto_clientes })
      .del();
      
      logger("SERVIDOR:postAfiliados").info("Parametrização excluida feita com sucesso");
      const rs = response("sucesso", 202, "Parametrização excluida feita com sucesso");
      return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
