const database = require('../config/database')
const response = require("../constants/response");
const logger = require('../services/loggerService');

module.exports.getTipo_usuario = async function() {
  try {
      const tipo_usuario = await database("tipo_usuario")
      .orderBy("id_tipo_usuario", "DESC");

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, tipo_usuario);
      return rs

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTipo_usuario_usuarios = async function(usuario, email, cat_nome_usuario) {
  try {
      const tipo_usuario = await database("tipo_usuario")
      .join("usuarios", "usuarios.tipo_usuario", "=", "tipo_usuario.id_tipo_usuario")
      .whereLike("nome_usuario",`%${usuario}%`)
      .whereLike("email_",`%${email}%`)
      .whereLike("tipo_nome_usuario",`%${cat_nome_usuario}%`)
      .orderBy("id_tipo_usuario", "DESC");

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, tipo_usuario);
      return rs

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTipo_usuario_usuariosID = async function(id_tipo_usuario, usuario, email, cat_nome_usuario) {
  try {
      const tipo_usuario = await database("tipo_usuario")
      .join("usuarios", "usuarios.tipo_usuario", "=", "tipo_usuario.id_tipo_usuario")
      .where({id_tipo_usuario})
      .whereLike("nome_usuario",`%${usuario}%`)
      .whereLike("email_",`%${email}%`)
      .whereLike("tipo_nome_usuario",`%${cat_nome_usuario}%`)
      .orderBy("id_tipo_usuario", "DESC");

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, tipo_usuario);
      return rs

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }

};

module.exports.postTipo_usuario = async function(dados) {
  try {

      logger("SERVIDOR:postTipo_usuario").debug("Á cadastrar afiliados no banco de dados");

      const resultTipoReg = await database("tipo_usuario")
      .where({tipo_nome_usuario: dados.tipo_nome_usuario});

      if (resultTipoReg.length){
        logger("SERVIDOR:postTipo_usuario").info("Tipo de usuario cadastrado!")
        const rs = response("erro", 409, "Tipo de usuario cadastrado!");
        return rs
      }

      logger("SERVIDOR:postTipo_usuario").debug("Á cadastrar no banco de dados");
      await database("tipo_usuario").insert(dados);

      logger("SERVIDOR:postTipo_usuario").info("Parametrização feita com sucesso");
      const rs = response("sucesso", 201, "Parametrização feita com sucesso");
      return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:postTipo_usuario").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }

};

module.exports.patchTipo_usuario = async function(id_tipo_usuario, dados) {
  try {

    const resultProduto = await database("tipo_usuario").where({ id_tipo_usuario });

    if (!resultProduto.length){
      logger("SERVIDOR:postAfiliados").info("Tipo usuarios não encontrado!")
      const rs = response("erro", 409, "Tipo usuario não encontrado!");
      return rs
    }

    await database("tipo_usuario").where({ id_tipo_usuario }).update(dados);
    
    logger("SERVIDOR:postAfiliados").info("Actualização feita com sucesso");
    const rs = response("sucesso", 202, "Actualização feita com sucesso");
    return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteTipo_usuario = async function(id_tipo_usuario) {
  try {

    logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
    const resultTipoReg = await database("tipo_usuario")
    .where({id_tipo_usuario});

    if (!resultTipoReg.length){
      logger("SERVIDOR:postAfiliados").info("Registro inexistente")
      const rs = response("erro", 409, "Registro inexistente");
      return rs
    }

    const resultTipoRegUsuarios = await database("tipo_usuario")
    .join("usuarios", "usuarios.tipo_usuario", "=", "tipo_usuario.id_tipo_usuario")
    .where({id_tipo_usuario});

    if (resultTipoRegUsuarios.length){
      logger("SERVIDOR:postAfiliados").info("Impossivel de excluir")
      const rs = response("erro", 409, "Não é possivel excluir, tem associação de usuarios");
      return rs
    }

    logger("SERVIDOR:postAfiliados").debug("Á cadastrar afiliados no banco de dados");
    await database("tipo_usuario")
    .where({ id_tipo_usuario })
    .del();
    
    logger("SERVIDOR:postAfiliados").info("Parametrização excluida feita com sucesso");
    const rs = response("sucesso", 202, "Parametrização excluida feita com sucesso");
    return rs;

  } catch (error) {
      console.log(error);
      logger("SERVIDOR:getAfiliados").error(`Erro ao buscar afiliados ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
