const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const {webhookFilteres, webhookTentativasFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords") 
const logger = require('../services/loggerService');

module.exports.getWebhook = async function(pagina, limite, total_registros, entidade, requisicao, url, enviado, tentativas) {
     
  try{
  
      const webhook = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("requesicao",`%${requisicao}%`)
      .whereLike("tentativas",`%${tentativas}%`)
      .whereLike("url",`%${url}%`)
      .whereLike("enviado",`%${enviado}%`)
      .whereLike("entidade_aceite",`%${entidade}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_logreq','DESC')

      const {registros} = paginationRecords(webhook, pagina, limite)

      const webhookLimite = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("requesicao",`%${requisicao}%`)
      .whereLike("tentativas",`%${tentativas}%`)
      .whereLike("url",`%${url}%`)
      .whereLike("enviado",`%${enviado}%`)
      .whereLike("entidade_aceite",`%${entidade}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_logreq','DESC')
      
      const filtered = webhookFilteres(webhookLimite)
      registros.total_apresentados = webhookLimite.length
      registros.entidade = entidade
      registros.tentativas = tentativas
      registros.url = url
      registros.requisicao = requisicao
      registros.enviado = enviado

      delete registros.count

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs
    
   } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getWebhookEntidade = async function(pagina, limite, total_registros, entidade, requisicao, url, enviado, tentativas) {
     
  try{

      const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

      if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
        const rs = response("erro", 423, "Serviço de pagamento inactivo");
        return rs    
      }

      const webhook = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("requesicao",`%${requisicao}%`)
      .whereLike("tentativas",`%${tentativas}%`)
      .whereLike("url",`%${url}%`)
      .whereLike("enviado",`%${enviado}%`)
      .where({entidade_aceite: entidade})
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_logreq','DESC')

      const {registros} = paginationRecords(webhook, pagina, limite)

      const webhookLimite = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("requesicao",`%${requisicao}%`)
      .whereLike("tentativas",`%${tentativas}%`)
      .whereLike("url",`%${url}%`)
      .whereLike("enviado",`%${enviado}%`)
      .where({entidade_aceite: entidade})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_logreq','DESC')
      
      const filtered = webhookFilteres(webhookLimite)
      registros.total_apresentados = webhookLimite.length
      registros.entidade = entidade
      registros.tentativas = tentativas
      registros.url = url
      registros.requisicao = requisicao
      registros.enviado = enviado

      delete registros.count

      logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs
    
   } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getWebhookIdLog = async function(id_logreq) {
     
  try{
  
      const webhook = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .andWhere({id_logreq})
      .orderBy('id_logreq','DESC')
      
      const [filtered] = webhookFilteres(webhook)

      const rs = response("sucesso", 200, filtered || {}, "json");
          
      return rs
    
   } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getWebhookLogsFalhas = async function(pagina, limite, total_registros, entidade, requisicao, url, enviado, tentativas) {
     
  try{
    
      const webhook = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("requesicao",`%${requisicao}%`)
      .whereLike("tentativas",`%${tentativas}%`)
      .whereLike("url",`%${url}%`)
      .whereLike("enviado",`%${enviado}%`)
      .whereLike("entidade_aceite",`%${entidade}%`)
      .andWhere("enviado","!=","SIM")
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_logreq','DESC')

      const {registros} = paginationRecords(webhook, pagina, limite)

      const webhookLimite = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
      .whereLike("requesicao",`%${requisicao}%`)
      .whereLike("tentativas",`%${tentativas}%`)
      .whereLike("url",`%${url}%`)
      .whereLike("enviado",`%${enviado}%`)
      .whereLike("entidade_aceite",`%${entidade}%`)
      .andWhere("enviado","!=","SIM")
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_logreq','DESC')
      
      const filtered = webhookFilteres(webhookLimite)
      registros.total_apresentados = webhookLimite.length
      registros.entidade = entidade
      registros.tentativas = tentativas
      registros.url = url
      registros.requisicao = requisicao
      registros.enviado = enviado

      delete registros.count

      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs
    
   } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getWebhookEntidadeLogsFalhas = async function(pagina, limite, total_registros, entidade, requisicao, url, enviado, tentativas) {
     
  try{

    const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

    if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
      const rs = response("erro", 423, "Serviço de pagamento inactivo");
      return rs    
    }

    const webhook = await database('webhooks_logs')
    .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
    .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
    .whereLike("requesicao",`%${requisicao}%`)
    .whereLike("tentativas",`%${tentativas}%`)
    .whereLike("url",`%${url}%`)
    .whereLike("enviado",`%${enviado}%`)
    .where({entidade_aceite: entidade})
    .andWhere("enviado","!=","SIM")
    .limit(total_registros || pagination.total_limite)
    .orderBy('id_logreq','DESC')

    const {registros} = paginationRecords(webhook, pagina, limite)

    const webhookLimite = await database('webhooks_logs')
    .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
    .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
    .whereLike("requesicao",`%${requisicao}%`)
    .whereLike("tentativas",`%${tentativas}%`)
    .whereLike("url",`%${url}%`)
    .whereLike("enviado",`%${enviado}%`)
    .where({entidade_aceite: entidade})
    .andWhere("enviado","!=","SIM")
    .limit(registros.limite)
    .offset(registros.count)
    .orderBy('id_logreq','DESC')
    
    const filtered = webhookFilteres(webhookLimite)
    registros.total_apresentados = webhookLimite.length
    registros.entidade = entidade
    registros.tentativas = tentativas
    registros.url = url
    registros.requisicao = requisicao
    registros.enviado = enviado

    delete registros.count

    const rs = response("sucesso", 200, filtered, "json",
    {
      registros
    });
        
    return rs
    
   } catch (error) {
    console.error(error.message)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
    
}

module.exports.getWebhookLogsFalhasTentativas = async function(log, pagina, limite, total_registros, entidade, requisicao, url, enviado) {
     
  try{

      const webhook = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .join('webhooks_logs_tentativas','webhooks_logs.id_logreq','=','webhooks_logs_tentativas.log')
      .whereLike("requesicao",`%${requisicao}%`)
      .whereLike("url",`%${url}%`)
      .whereLike("enviado",`%${enviado}%`)
      .whereLike("entidade_aceite",`%${entidade}%`)
      .where({log})
      .andWhere("enviado","!=","SIM")
      .limit(total_registros || pagination.total_limite)
      .orderBy('id_logs_tentativa','DESC')

      const {registros} = paginationRecords(webhook, pagina, limite)

      const webhookLimite = await database('webhooks_logs')
      .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
      .join('webhooks_logs_tentativas','webhooks_logs.id_logreq','=','webhooks_logs_tentativas.log')
      .whereLike("requesicao",`%${requisicao}%`)
      .whereLike("url",`%${url}%`)
      .whereLike("enviado",`%${enviado}%`)
      .whereLike("entidade_aceite",`%${entidade}%`)
      .where({log})
      .andWhere("enviado","!=","SIM")
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_logs_tentativa','DESC')
      
      const filtered = webhookTentativasFilteres(webhookLimite)
      registros.total_apresentados = webhookLimite.length 
      registros.entidade = entidade
      registros.url = url
      registros.requisicao = requisicao
      registros.enviado = enviado

      delete registros.count

      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs
    
   } catch (error) {
      console.error(error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getWebhookEntidadeLogsFalhasTentativas = async function(log, pagina, limite, total_registros, entidade, requisicao, url, enviado) {
     
  try{

    const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

    if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
      const rs = response("erro", 423, "Serviço de pagamento inactivo");
      return rs    
    }

    const webhook = await database('webhooks_logs')
    .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
    .join('webhooks_logs_tentativas','webhooks_logs.id_logreq','=','webhooks_logs_tentativas.log')
    .where({log})
    .andWhere({entidade_aceite: entidade})
    .andWhere("enviado","!=","SIM")
    .limit(total_registros || pagination.total_limite)
    .orderBy('id_logs_tentativa','DESC')

    const {registros} = paginationRecords(webhook, pagina, limite)

    const webhookLimite = await database('webhooks_logs')
    .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
    .join('webhooks_logs_tentativas','webhooks_logs.id_logreq','=','webhooks_logs_tentativas.log')
    .where({log})
    .andWhere({entidade_aceite: entidade})
    .andWhere("enviado","!=","SIM")
    .limit(registros.limite)
    .offset(registros.count)
    .orderBy('id_logs_tentativa','DESC')
    
    const filtered = webhookTentativasFilteres(webhookLimite)
    registros.total_apresentados = webhookLimite.length
    registros.entidade = entidade
    registros.url = url
    registros.requisicao = requisicao
    registros.enviado = enviado

    delete registros.count

    const rs = response("sucesso", 200, filtered, "json",
    {
      registros
    });
        
    return rs
    
   } catch (error) {
    console.error(error.message)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
    
}

module.exports.getWebhookLogsPesquisar = async function(entidade, pagina, limite, total_registros, dia_inicio, dia_final, entidade, requisicao, url, enviado, tentativas) {
     
  try{
   
   const webhook = await database('webhooks_logs')
   .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
   .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
   .whereBetween("data_evento",[dia_inicio, dia_final])
   .whereLike("requesicao",`%${requisicao}%`)
   .whereLike("tentativas",`%${tentativas}%`)
   .whereLike("url",`%${url}%`)
   .whereLike("enviado",`%${enviado}%`)
   .whereLike("entidade_aceite",`%${entidade}%`)
   .limit(total_registros || pagination.total_limite)
   .orderBy('id_logreq','DESC')
   
   
   const {registros} = paginationRecords(webhook, pagina, limite)

   const webhookLimite = await database('webhooks_logs')
   .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
   .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
   .whereBetween("data_evento",[dia_inicio, dia_final])
   .whereLike("requesicao",`%${requisicao}%`)
   .whereLike("tentativas",`%${tentativas}%`)
   .whereLike("url",`%${url}%`)
   .whereLike("enviado",`%${enviado}%`)
   .whereLike("entidade_aceite",`%${entidade}%`)
   .limit(registros.limite)
   .offset(registros.count)   
   .orderBy('id_logreq','DESC')
   
   const filtered = webhookFilteres(webhookLimite)
    registros.total_apresentados = webhookLimite.length
    registros.dia_inicio = dia_inicio
    registros.dia_final = dia_final
    registros.entidade = entidade
    registros.tentativas = tentativas
    registros.url = url
    registros.requisicao = requisicao
    registros.enviado = enviado

   delete registros.count

   const rs = response("sucesso", 200, filtered, "json",
   {
     registros
   });
       
   return rs     
   
   
  } catch (error) {
   console.error(error.message)
   const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
   return rs
 }
 
}

module.exports.getWebhookEntidadeLogsPesquisar = async function(entidade, pagina, limite, total_registros, dia_inicio, dia_final, entidade, requisicao, url, enviado, tentativas) {
     
  try{

   const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: entidade})        

   if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
     const rs = response("erro", 423, "Serviço de pagamento inactivo");
     return rs    
   }
   
   const webhook = await database('webhooks_logs')
   .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
   .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
   .whereBetween("data_evento",[dia_inicio, dia_final])
   .whereLike("requesicao",`%${requisicao}%`)
   .whereLike("tentativas",`%${tentativas}%`)
   .whereLike("url",`%${url}%`)
   .whereLike("enviado",`%${enviado}%`)
   .where({entidade_aceite: entidade})
   .limit(total_registros || pagination.total_limite)
   .orderBy('id_logreq','DESC')
   
   
   const {registros} = paginationRecords(webhook, pagina, limite)

   const webhookLimite = await database('webhooks_logs')
   .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
   .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
   .whereBetween("data_evento",[dia_inicio, dia_final])
   .whereLike("requesicao",`%${requisicao}%`)
   .whereLike("tentativas",`%${tentativas}%`)
   .whereLike("url",`%${url}%`)
   .whereLike("enviado",`%${enviado}%`)
   .where({entidade_aceite: entidade})
   .limit(registros.limite)
   .offset(registros.count)   
   .orderBy('id_logreq','DESC')
   
   const filtered = webhookFilteres(webhookLimite)
    registros.total_apresentados = webhookLimite.length
    registros.dia_inicio = dia_inicio
    registros.dia_final = dia_final
    registros.entidade = entidade
    registros.tentativas = tentativas
    registros.url = url
    registros.requisicao = requisicao
    registros.enviado = enviado

   delete registros.count

   const rs = response("sucesso", 200, filtered, "json",
   {
     registros
   });
       
   return rs     
   
   
  } catch (error) {
   console.error(error.message)
   const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
   return rs
 }
 
}

module.exports.patchWebhookLogsFalhasTentativasReenviar = async function(numero_entidade, log) {
     
  try{

    const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: numero_entidade})        

    if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
      const rs = response("erro", 423, "Serviço de pagamento inactivo");
      return rs    
    }

    const webhook = await database('webhooks_logs')
    .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
    .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
    .where({id_logreq: log})
    .andWhere({entidade_aceite: numero_entidade})
    .andWhere("enviado","!=","SIM")
    .orderBy('id_logreq','DESC')

    console.log(webhook)
    

    if(!webhook.length) {
        const rs = response("erro", 406, "Não podemos reenviar a requisição. Fala com o administrador");
        return rs
    }

    const [filtered] = webhook

    let enviado = 'CANCELADO'

    if(filtered.tentativas > 20) enviado = 'FALHA'

    await database('webhooks_logs').where({id_logreq: log}).update({enviado})

    const updateRequest = {
      id_logreq: log,
      id_evento: filtered.id_evento,
      entidade: filtered.entidade_aceite,
      info: filtered
    }

    const rs = response("sucesso", 202, "Requisição reenviada com sucesso. Aguarde o reenvio", "json",
    {
      webhook: updateRequest,
      info: {...filtered, enviado}
    });
        
    return rs
    
   } catch (error) {
    console.error(error.message)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
    
}

module.exports.patchWebhookLRefazerReenvio = async function(numero_entidade, log) {
     
  try{

    const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: numero_entidade})        

    if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
      const rs = response("erro", 423, "Serviço de pagamento inactivo");
      return rs    
    }

    const webhook = await database('webhooks_logs')
    .join('webhooks_endpoints','webhooks_endpoints.id_endpoint','=','webhooks_logs.endpoint')
    .leftJoin('webhooks_eventos','webhooks_eventos.id_evento','=','webhooks_endpoints.evento')
    .where({id_logreq: log})
    .andWhere({entidade_aceite: numero_entidade})
    .andWhere("enviado","!=","SIM")
    .orderBy('id_logreq','DESC')
    

    if(!webhook.length) {
        const rs = response("erro", 406, "Não podemos reenviar a requisição. Fala com o administrador");
        return rs
    }

    const [filtered] = webhook

    const enviado = 'NÃO'
    const timestamp_log = Date.now()

    await database('webhooks_logs').where({id_logreq: log}).update({enviado, tentativas: "0", timestamp_log, proximoRetryEmSegundo: "0", tempoPercorrido: "0"})

    const updateRequest = {
      id_logreq: log,
      id_evento: filtered.id_evento,
      entidade: filtered.entidade_aceite,
      info: filtered
    }

    const rs = response("sucesso", 202, "Requisição refeita com sucesso. Aguarde o reenvio", "json",
    {
      webhook: updateRequest,
      info: {...filtered, enviado}
    });
        
    return rs
    
   } catch (error) {
    console.error(error.message)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
    
}

module.exports.postWebhookLPagamentoTransacao = async function(numero_entidade, periodo, id_transacao) {
     
  try{

    const verifivarPagamentoTempoReal = await database('configuracoes').where({cliente_entidade: numero_entidade})        

    if(verifivarPagamentoTempoReal[0].servico_pagamento_por_sector == "false"){
      const rs = response("erro", 423, "Serviço de pagamento inactivo");
      return rs    
    }

    const pegarEndpoint = await database('webhooks_endpoints').where({entidade_aceite: numero_entidade})

    if(pegarEndpoint.length < 0){
      const rs = response("erro", 406, "Entidade sem endpoint cadastrado");
      return rs 
    }

    let evento = 8
    for (const element of pegarEndpoint) {
        if(element.evento == 8 || element.evento == 10 || element.evento == 9)
          evento = element.evento
    }

    const pagamento = await database('pagamentos')
    .join("referencias","referencias.num_referencia","=","pagamentos.referencia_do_servico")
    .join("produtos_clientes","produtos_clientes.id_produto","=","referencias.indicador_produto_id")
    .join("tipo_produto","tipo_produto.id_tipo_produto","=","referencias.tipo_de_registro")
    .where("Identificacao_Log_EGR",periodo)
    .andWhere("numero_Log_EGR",id_transacao)
    .andWhere({numero_entidade})
    .orderBy('id_pagamento','desc')

    if(!pagamento.length){
      const rs = response("erro", 409, "Registro de pagamento não encontrado");
      return rs 
    }

    const [campos] =  pagamento

    campos.id_evento = evento;
    campos.total_transicao = campos.montante_da_operacao;

    let reference = await database('referencias')
    .where({num_referencia: campos.referencia_da_transacao ||  campos.num_referencia })
    .andWhere({entidade_cliente: numero_entidade})

    const pegarEndpointEntidade = await database('webhooks_endpoints').where({entidade_aceite: numero_entidade}).andWhere({tipo_endpoint:"PRIMAVERA"});

    // Campo endpoint Primavera
    let PrimaveraCampo = null
    if(pegarEndpointEntidade.length)
        PrimaveraCampo = reference[0][pegarEndpointEntidade[0]?.campo_codigo_cliente_primavera] || null
    
    const update = {
      id_evento: campos.id_evento,
      entidade_aceite: campos.entidade_aceite,
      dados: {...campos, clientePRIMAVERA: PrimaveraCampo}
    }

    const rs = response("sucesso", 201, "Requisição enviada com sucesso.", "json",
    {
      webhook:{id_evento: update.id_evento, entidade: update.entidade_aceite, info: update.dados},
      info: update
    });
        
    return rs
    
   } catch (error) {
    console.error(error.message)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
    
}



