const express = require('express');
const router = express.Router();
const controller = require('../controllers/afiliados');

/* GET afiliados listing. */
router.get('/', controller.getAfiliados);

router.get('/:id_afiliado', controller.getAfiliadosId);

router.get('/hash/:hash', controller.getAfiliadosHash);  

router.get('/:id_afiliado/entidade/:entidade', controller.getAfiliadosIdComEntidade);

router.get('/:id_afiliado/entidade/:entidade/permissoes', controller.getAfiliadosIdComEntidadePermissoes);

router.get('/identificacao/:id_identificacao_afiliados', controller.getAfiliadosIdIdentificador);

router.get('/identificacao/entidades/:entidade', controller.getAfiliadosComEntidadeIdentificadores);

router.get('/identificacao/:id_identificacao_afiliados/entidades/:entidade', controller.getAfiliadosIdComEntidadeIdentificador);

router.get('/identificacao/:id_identificacao_afiliados/entidades/:entidade/afiliados', controller.getAfiliadosIdComEntidadeIdentificadorAfiliados);

router.get('/entidade/:entidade', controller.getAfiliadosEntidade);


/* POST afiliados listing. */
router.post('/', controller.postAfiliados);
router.post('/afiliados-indetificacao', controller.postAfiliadosIdentificador);

router.post('/login', controller.postAfiliadosLogin);

router.post('/logout', controller.postAfiliadosLogout);

/* PATH afiliados listing. */
router.patch('/:id_afiliado', controller.patchAfiliados);
router.patch('/:id_afiliado/alternar-estado', controller.patchAfiliadosAlternarEstado);
router.patch('/:id_afiliado/mudar-senha', controller.patchAfiliadosMudarSenha); //
router.patch('/:id_afiliado/permissoes', controller.patchAfiliadosPermissoes); 

/* DELETE afiliados listing. */
router.delete('/:id_afiliado', controller.deleteAfiliados);



module.exports = router;
