const express = require('express');
const router = express.Router();
const controller = require('../controllers/credencial');

/* GET credenciais listing. */
router.get('/', controller.getCredencial);

router.get('/:id_credencial', controller.getCredencialId);

router.get('/entidade/:entidade', controller.getCredencialEntidade);

/* POST credenciais listing. */
router.post('/', controller.postCredencial);

/* PATH credenciais listing. */
router.patch('/:entidade', controller.patchCredencial);

/* PATH credenciais listing. */
router.patch('/chave-de-segredo/:entidade', controller.patchCredencialSecreteKey);

/* DELETE credenciais listing. */
router.delete('/:entidade', controller.deleteCredencial);



module.exports = router;
