const express = require('express');
const router = express.Router();
const controller = require('../controllers/endpoints');

/* GET Endpoints listing. */
router.get('/', controller.getEndpoints); 

router.get('/:id_endpoint', controller.getEndpointsID);

/* GET ONE WITH ENTIDADE Endpoints listing. */
router.get('/entidade/:entidade_aceite', controller.getEndpointsEntidade);

/* POST Endpoints listing. */
router.post('/', controller.postEndpoints);

/* PATH Endpoints listing. */
router.patch('/:id_endpoint', controller.patchEndpoints);

router.patch('/:id_endpoint/alternar-estado', controller.patchEndpointsAlternarEstado);

/* DELETE Endpoints listing. */   
router.delete('/:id_endpoint', controller.deleteEndpoints);


module.exports = router;
