const express = require('express');
const router = express.Router();
const controller = require('../controllers/eventos');

/* GET Eventos listing. */
router.get('/', controller.getEventos);

/* GET ONE WITH ID Eventos listing. */
router.get('/:id_evento', controller.getEventosID);

/* POST Eventos listing. */
router.post('/', controller.postEventos);

/* PATH Eventos listing. */
router.patch('/id_evento', controller.patchEventos);

/* DELETE Eventos listing. */   
router.delete('/id_evento', controller.deleteEventos);



module.exports = router;
