const express = require('express');
const router = express.Router();
const controller = require('../controllers/ficheiros');

/* GET ficheiros listing. */
router.get('/', controller.getFicheiros);

router.get('/:idficheiros', controller.getFicheirosId);

router.get('/arquivos/movimentos', controller.getFicheirosMovimentos);

router.get('/sequencia/:sequencia', controller.getFicheirosSequencia);

router.get('/entidade/:entidade', controller.getFicheirosEntidade);

router.get('/entidade/:entidade/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getFicheirosEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getFicheirosDias);

router.get('/tipo/:tipo', controller.getFicheirosTipo);

router.get('/arquivo/:arquivo', controller.getFicheirosArquivo);

/* POST ficheiros listing. */

router.post('/enviar-relatorios-transacoes', controller.postFicheirosEnviarRelatoriosTranscoes)

module.exports = router; 