const express = require('express');
const router = express.Router();
const controller = require('../controllers/notificacoes');

/* GET notificações listing. */
router.get('/', controller.getNotificacoes); 

router.get('/:id_notficacao_entidade', controller.getNotificacoesId);

router.get('/entidade/:entidade_notificada', controller.getNotificacoesEntidade);

router.get('/entidade/:entidade_notificada/lidas', controller.getNotificacoesEntidadeLidas);

router.get('/entidade/:entidade_notificada/nao-lidas', controller.getNotificacoesEntidadeNaoLidas);

router.get('/entidade/:entidade_notificada/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getNotificacoesEntidadeDias);

/* PATCH notificações listing. */
router.patch('/entidade/:entidade_notificada/marcar-como-lida/:id_notficacao_entidade', controller.patchNotificacaoMarcarComoLida);

router.patch('/entidade/:entidade_notificada/marcar-como-nao-lida/:id_notficacao_entidade', controller.patchNotificacaoMarcarComoNaoLida);






module.exports = router;