const express = require('express');
const router = express.Router();
const controller = require('../controllers/pagamentos');

/* GET pagamentos listing. */
router.get('/', controller.getPagamentos);

router.get('/:id_pagamento', controller.getPagamentosId);

router.get('/referencia/:referencia', controller.getPagamentosReferencia);

router.get('/periodo/:periodo', controller.getPagamentosPeriodo);

router.get('/entidade/:numero_entidade', controller.getPagamentosEntidade);

router.get('/entidade/:numero_entidade/periodo/:periodo', controller.getPagamentosEntidadePeriodo);

router.get('/entidade/:numero_entidade/referencia/:referencia', controller.getPagamentosEntidadeReferencia);

router.get('/entidade/:numero_entidade/grupo/:grupo_identificacao', controller.getPagamentosEntidadeGrupoAfiliados);

router.get('/entidade/:numero_entidade/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPagamentosEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPagamentosDias);

module.exports = router;