const express = require('express');
const router = express.Router();
const controller = require('../controllers/pagamentos_incompletos');

/* GET pagamentos Incompletos listing. */
router.get('/', controller.getPagamentosIncompletos);

router.get('/:id_pagamento', controller.getPagamentosIncompletosId);

router.get('/referencia/:referencia', controller.getPagamentosIncompletosReferencia);

router.get('/periodo/:periodo', controller.getPagamentosIncompletosPeriodo);

router.get('/entidade/:numero_entidade', controller.getPagamentosIncompletosEntidade);

router.get('/entidade/:numero_entidade/periodo/:periodo', controller.getPagamentosIncompletosEntidadePeriodo);

router.get('/entidade/:numero_entidade/referencia/:referencia', controller.getPagamentosIncompletosEntidadeReferencia);

router.get('/entidade/:numero_entidade/grupo/:grupo_identificacao', controller.getPagamentosIncompletosEntidadeGrupoAfiliados);

router.get('/entidade/:numero_entidade/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPagamentosIncompletosEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPagamentosIncompletosDias);

module.exports = router;