const express = require('express');
const router = express.Router();
const controller = require('../controllers/periodos');

/* GET periodos listing. */
router.get('/', controller.getPeriodos);

router.get('/ver/mesclados', controller.getPeriodosMesclados);

router.get('/ver/mesclados/entidade/:numero_entidade', controller.getPeriodosMescladosPorEntidade);

router.get('/:periodo', controller.getPeriodosPeriodo);

router.get('/:periodo/entidade/:numero_entidade', controller.getPeriodosEntidadePeriodo);

router.get('/:periodo/contabilidade', controller.getPeriodosContabilidade);

router.get('/:periodo/contabilidade/:data', controller.getPeriodosContabilidadeData);

router.get('/:periodo/entidade/:numero_entidade/contabilidade', controller.getPeriodosEntidadeContabilidade);

router.get('/:periodo/entidade/:numero_entidade/contabilidade/:data', controller.getPeriodosEntidadeContabilidadeData);

router.get('/referencia/:referencia/ver', controller.getPeriodosReferencia);

router.get('/entidade/:numero_entidade/ver', controller.getPeriodosEntidade);

router.get('/entidade/:numero_entidade/referencia/:referencia/ver', controller.getPeriodosEntidadeReferencia);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPeriodosPesquisar);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final/mesclados', controller.getPeriodosPesquisarMesclados);

router.get('/entidade/:numero_entidade/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPeriodosEntidadePesquisar);

router.get('/entidade/:numero_entidade/dia-inicio/:dia_inicio/dia-final/:dia_final/mesclados', controller.getPeriodosEntidadePesquisarMesclados);


module.exports = router; 