const express = require('express');
const router = express.Router();
const controller = require('../controllers/produtos_valores_fixos');

/* GET Valores Fixos listing. */
router.get('/', controller.getFixos);

/* GET ONE WITH ID Valores Fixos listing. */
router.get('/:id_fixo', controller.getFixosID);

/* GET ONE WITH ID Valores Fixos listing. */
router.get('/entidade/:entidade_produdo', controller.getFixosEntidade);

/* POST Valores Fixos listing. */
router.post('/', controller.postFixos);

/* PATH Valores Fixos listing. */
router.patch('/:id_fixo', controller.patchFixos);

/* DELETE Valores Fixos listing. */   
router.delete('/:id_fixo', controller.deleteFixos);



module.exports = router;
