const express = require('express');
const router = express.Router();
const controller = require('../controllers/referencias');

/* GET usuarios listing. */
router.get('/', controller.getReferencias);

router.get('/:id_referencia', controller.getReferenciaId);

router.get('/referencia/:num_referencia', controller.getReferenciaReferencia);

router.get('/referencia/:num_referencia/:numero_entidade', controller.getReferenciaReferenciaEntidade);

router.get('/entidade/:entidade_cliente', controller.getReferenciasEntidade);

router.get('/entidade/:entidade_cliente/grupo/:grupo_identificacao', controller.getReferenciasEntidadeGrupoAfiliados);

router.get('/entidade/:entidade_cliente/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getReferenciasEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getReferenciasDias);

/* GET usuarios listing. */

router.post('/', controller.postReferencia);

router.post('/importar/xml', controller.importarXML);
   
/* GET usuarios listing. */
router.patch('/:id_referencia', controller.patchReferencia)

/* GET usuarios listing. */
router.delete('/:id_referencia', controller.deleteReferencia)



module.exports = router;