const express = require('express');
const router = express.Router();
const controller = require('../controllers/transacoes');
const protected = require('../config/authToken');

/* GET usuarios listing. */
router.get('/', controller.getTransacoes);
 
router.get('/:id_transaccao', controller.getTransacoesId);

router.get('/pagamento/:pagamento', controller.getTransacoesPagamento);

router.get('/entidade/:numero_entidade', controller.getTransacoesEntidade);

router.get('/por-custo-de-uso/:numero_entidade', controller.getTransacoesPorEntidade);

router.get('/agrupado/entidades', controller.getTransacoesAgrudadoPorEntidade);

router.get('/agrupado/entidades/somatorio', controller.getTransacoesAgrudadoPorEntidadeSomatoria);

router.get('/agrupado/entidades/somatorio-diario/:data', controller.getTransacoesAgrudadoPorEntidadeSomatoriaDiario);

router.get('/agrupado/entidades/somatorio-mensal/:data', controller.getTransacoesAgrudadoPorEntidadeSomatoriaMensal);

router.get('/agrupado/entidades/somatorio/:entidade', controller.getTransacoesAgrudadoPorEntidadeSomatoriaEntidade);

router.get('/agrupado/entidades/somatorio/:entidade/mensalidades', controller.getTransacoesAgrudadoPorEntidadeSomatoriaEntidadeMensalidades);

router.get('/entidade/:entidade/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getTransacoesEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getTransacoesDias);

/* GET usuarios listing. */
router.post('/relatorio', controller.postRelatorioTransacao);

router.post('/pesquisar', controller.postTransacaoPesquisar);
 




module.exports = router;