const express = require('express');
const router = express.Router();
const controller = require('../controllers/webhook');

// /* POST LogReq listing. */
router.get('/', controller.getWebhook);

router.get('/:id_logreq', controller.getWebhookIdLog);

router.get('/entidade/:entidade', controller.getWebhookEntidade);

router.get('/logs/falhas', controller.getWebhookLogsFalhas);

router.get('/entidade/:entidade/logs/falhas', controller.getWebhookEntidadeLogsFalhas);

router.get('/logs/falhas/tentativas/:log', controller.getWebhookLogsFalhasTentativas);

router.get('/entidade/:entidade/logs/falhas/tentativas/:log', controller.getWebhookEntidadeLogsFalhasTentativas);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getWebhookLogsPesquisar);

router.get('/entidade/:entidade/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getWebhookEntidadeLogsPesquisar);

// /* POST LogReq listing. */
router.patch('/entidade/:entidade/logs/:log/reenviar', controller.patchWebhookLogsFalhasTentativasReenviar);

router.patch('/entidade/:entidade/logs/:log/refazer-reenvio', controller.patchWebhookLRefazerReenvio);

// /* POST LogReq listing. */
router.post('/entidade/:entidade/periodo/:periodo/transacao/:id_transacao/pagamento-reenviar', controller.postWebhookLPagamentoTransacao);

 
module.exports = router;
